/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.codecentric.boot.admin.config.AdminServerProperties;
import de.codecentric.boot.admin.controller.JournalController;
import de.codecentric.boot.admin.controller.RegistryController;
import de.codecentric.boot.admin.event.ClientApplicationDeregisteredEvent;
import de.codecentric.boot.admin.event.ClientApplicationRegisteredEvent;
import de.codecentric.boot.admin.event.RoutesOutdatedEvent;
import de.codecentric.boot.admin.journal.ApplicationEventJournal;
import de.codecentric.boot.admin.journal.store.JournaledEventStore;
import de.codecentric.boot.admin.journal.store.SimpleJournaledEventStore;
import de.codecentric.boot.admin.registry.ApplicationIdGenerator;
import de.codecentric.boot.admin.registry.ApplicationRegistry;
import de.codecentric.boot.admin.registry.HashingApplicationUrlIdGenerator;
import de.codecentric.boot.admin.registry.StatusUpdater;
import de.codecentric.boot.admin.registry.store.ApplicationStore;
import de.codecentric.boot.admin.registry.store.SimpleApplicationStore;
import de.codecentric.boot.admin.web.PrefixHandlerMapping;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.EventListener;
import org.springframework.http.HttpStatus;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.scheduling.config.ScheduledTaskRegistrar;
import org.springframework.util.StringUtils;
import org.springframework.web.client.DefaultResponseErrorHandler;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.ViewControllerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

@Configuration
@EnableConfigurationProperties
public class AdminServerWebConfiguration
extends WebMvcConfigurerAdapter
implements ApplicationContextAware {
    private ApplicationContext applicationContext;
    @Autowired
    private ApplicationEventPublisher publisher;
    @Autowired
    private ApplicationStore applicationStore;
    @Autowired
    private ServerProperties server;

    @Bean
    @ConditionalOnMissingBean
    public AdminServerProperties adminServerProperties() {
        return new AdminServerProperties();
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void extendMessageConverters(List<HttpMessageConverter<?>> converters) {
        if (!this.hasConverter(converters, MappingJackson2HttpMessageConverter.class)) {
            ObjectMapper objectMapper = Jackson2ObjectMapperBuilder.json().applicationContext(this.applicationContext).build();
            converters.add((HttpMessageConverter<?>)new MappingJackson2HttpMessageConverter(objectMapper));
        }
    }

    private boolean hasConverter(List<HttpMessageConverter<?>> converters, Class<? extends HttpMessageConverter<?>> clazz) {
        for (HttpMessageConverter<?> converter : converters) {
            if (!clazz.isInstance(converter)) continue;
            return true;
        }
        return false;
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler(new String[]{this.adminServerProperties().getContextPath() + "/**"}).addResourceLocations(new String[]{"classpath:/META-INF/spring-boot-admin-server-ui/"});
    }

    public void addViewControllers(ViewControllerRegistry registry) {
        if (StringUtils.hasText((String)this.adminServerProperties().getContextPath())) {
            registry.addRedirectViewController(this.adminServerProperties().getContextPath(), this.server.getPath(this.adminServerProperties().getContextPath()) + "/");
        }
        registry.addViewController(this.adminServerProperties().getContextPath() + "/").setViewName("forward:index.html");
    }

    @Bean
    public PrefixHandlerMapping prefixHandlerMapping() {
        PrefixHandlerMapping prefixHandlerMapping = new PrefixHandlerMapping(this.registryController(), this.journalController());
        prefixHandlerMapping.setPrefix(this.adminServerProperties().getContextPath());
        return prefixHandlerMapping;
    }

    @Bean
    public RegistryController registryController() {
        return new RegistryController(this.applicationRegistry());
    }

    @Bean
    public ApplicationRegistry applicationRegistry() {
        return new ApplicationRegistry(this.applicationStore, this.applicationIdGenerator());
    }

    @Bean
    @ConditionalOnMissingBean
    public ApplicationIdGenerator applicationIdGenerator() {
        return new HashingApplicationUrlIdGenerator();
    }

    @Bean
    @ConditionalOnMissingBean
    public StatusUpdater statusUpdater() {
        RestTemplate template = new RestTemplate();
        template.getMessageConverters().add(new MappingJackson2HttpMessageConverter());
        template.setErrorHandler((ResponseErrorHandler)new DefaultResponseErrorHandler(){

            protected boolean hasError(HttpStatus statusCode) {
                return false;
            }
        });
        StatusUpdater statusUpdater = new StatusUpdater(template, this.applicationStore);
        statusUpdater.setStatusLifetime(this.adminServerProperties().getMonitor().getStatusLifetime());
        return statusUpdater;
    }

    @EventListener
    public void onClientApplicationRegistered(ClientApplicationRegisteredEvent event) {
        this.statusUpdater().updateStatus(event.getApplication());
        this.publisher.publishEvent((Object)new RoutesOutdatedEvent());
    }

    @EventListener
    public void onClientApplicationDeregistered(ClientApplicationDeregisteredEvent event) {
        this.publisher.publishEvent((Object)new RoutesOutdatedEvent());
    }

    @Bean
    public ScheduledTaskRegistrar updateTaskRegistrar() {
        return new ScheduledTaskRegistrar();
    }

    @EventListener
    public void onApplicationReadyEvent(ApplicationReadyEvent event) {
        this.updateTaskRegistrar().addFixedRateTask(new Runnable(){

            @Override
            public void run() {
                AdminServerWebConfiguration.this.statusUpdater().updateStatusForAllApplications();
            }
        }, this.adminServerProperties().getMonitor().getPeriod());
        this.updateTaskRegistrar().afterPropertiesSet();
    }

    @Bean
    @ConditionalOnMissingBean
    public ApplicationEventJournal applicationEventJournal() {
        return new ApplicationEventJournal(this.journaledEventStore());
    }

    @Bean
    @ConditionalOnMissingBean
    public JournaledEventStore journaledEventStore() {
        return new SimpleJournaledEventStore();
    }

    @Bean
    @ConditionalOnMissingBean
    public JournalController journalController() {
        return new JournalController(this.applicationEventJournal());
    }

    @Bean
    @ConditionalOnMissingBean
    public ApplicationStore applicationStore() {
        return new SimpleApplicationStore();
    }
}

