/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.config;

import de.codecentric.boot.admin.notify.CompositeNotifier;
import de.codecentric.boot.admin.notify.HipchatNotifier;
import de.codecentric.boot.admin.notify.MailNotifier;
import de.codecentric.boot.admin.notify.Notifier;
import de.codecentric.boot.admin.notify.NotifierListener;
import de.codecentric.boot.admin.notify.PagerdutyNotifier;
import de.codecentric.boot.admin.notify.SlackNotifier;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnSingleCandidate;
import org.springframework.boot.autoconfigure.condition.NoneNestedConditions;
import org.springframework.boot.autoconfigure.mail.MailSenderAutoConfiguration;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.context.annotation.Primary;
import org.springframework.mail.MailSender;

@Configuration
public class NotifierConfiguration {

    @Configuration
    @ConditionalOnProperty(prefix="spring.boot.admin.notify.slack", name={"webhook-url"})
    @AutoConfigureBefore(value={NotifierListenerConfiguration.class, CompositeNotifierConfiguration.class})
    public static class SlackNotifierConfiguration {
        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnProperty(prefix="spring.boot.admin.notify.slack", name={"enabled"}, matchIfMissing=true)
        @ConfigurationProperties(value="spring.boot.admin.notify.slack")
        public SlackNotifier slackNotifier() {
            return new SlackNotifier();
        }
    }

    @Configuration
    @ConditionalOnProperty(prefix="spring.boot.admin.notify.hipchat", name={"url"})
    @AutoConfigureBefore(value={NotifierListenerConfiguration.class, CompositeNotifierConfiguration.class})
    public static class HipchatNotifierConfiguration {
        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnProperty(prefix="spring.boot.admin.notify.hipchat", name={"enabled"}, matchIfMissing=true)
        @ConfigurationProperties(value="spring.boot.admin.notify.hipchat")
        public HipchatNotifier hipchatNotifier() {
            return new HipchatNotifier();
        }
    }

    @Configuration
    @ConditionalOnProperty(prefix="spring.boot.admin.notify.pagerduty", name={"service-key"})
    @AutoConfigureBefore(value={NotifierListenerConfiguration.class, CompositeNotifierConfiguration.class})
    public static class PagerdutyNotifierConfiguration {
        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnProperty(prefix="spring.boot.admin.notify.pagerduty", name={"enabled"}, matchIfMissing=true)
        @ConfigurationProperties(value="spring.boot.admin.notify.pagerduty")
        public PagerdutyNotifier pagerdutyNotifier() {
            return new PagerdutyNotifier();
        }
    }

    @Configuration
    @ConditionalOnBean(value={MailSender.class})
    @AutoConfigureAfter(value={MailSenderAutoConfiguration.class})
    @AutoConfigureBefore(value={NotifierListenerConfiguration.class, CompositeNotifierConfiguration.class})
    public static class MailNotifierConfiguration {
        @Autowired
        private MailSender mailSender;

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnProperty(prefix="spring.boot.admin.notify.mail", name={"enabled"}, matchIfMissing=true)
        @ConfigurationProperties(value="spring.boot.admin.notify.mail")
        public MailNotifier mailNotifier() {
            return new MailNotifier(this.mailSender);
        }
    }

    @Configuration
    @ConditionalOnBean(value={Notifier.class})
    @AutoConfigureBefore(value={NotifierListenerConfiguration.class})
    public static class CompositeNotifierConfiguration {
        @Bean
        @Primary
        @Conditional(value={NoSingleNotifierCandidateCondition.class})
        public CompositeNotifier compositeNotifier(List<Notifier> notifiers) {
            return new CompositeNotifier(notifiers);
        }

        static class NoSingleNotifierCandidateCondition
        extends NoneNestedConditions {
            NoSingleNotifierCandidateCondition() {
                super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
            }

            @ConditionalOnSingleCandidate(value=Notifier.class)
            static class HasSingleNotifierInstance {
                HasSingleNotifierInstance() {
                }
            }
        }
    }

    @Configuration
    @ConditionalOnBean(value={Notifier.class})
    public static class NotifierListenerConfiguration {
        @Autowired
        public Notifier notifier;

        @Bean
        @ConditionalOnMissingBean
        public NotifierListener notifierListener() {
            return new NotifierListener(this.notifier);
        }
    }
}

