/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.controller;

import de.codecentric.boot.admin.model.Application;
import de.codecentric.boot.admin.registry.ApplicationRegistry;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@ResponseBody
public class RegistryController {
    private static final Logger LOGGER = LoggerFactory.getLogger(RegistryController.class);
    private final ApplicationRegistry registry;

    public RegistryController(ApplicationRegistry registry) {
        this.registry = registry;
    }

    @RequestMapping(value={"/api/applications"}, method={RequestMethod.POST})
    public ResponseEntity<Application> register(@RequestBody Application app) {
        LOGGER.debug("Register application {}", (Object)app.toString());
        Application registeredApp = this.registry.register(app);
        return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body((Object)registeredApp);
    }

    @RequestMapping(value={"/api/applications"}, method={RequestMethod.GET})
    public Collection<Application> applications(@RequestParam(value="name", required=false) String name) {
        LOGGER.debug("Deliver registered applications with name={}", (Object)name);
        if (name == null || name.isEmpty()) {
            return this.registry.getApplications();
        }
        return this.registry.getApplicationsByName(name);
    }

    @RequestMapping(value={"/api/applications/{id}"}, method={RequestMethod.GET})
    public ResponseEntity<?> get(@PathVariable String id) {
        LOGGER.debug("Deliver registered application with ID '{}'", (Object)id);
        Application application = this.registry.getApplication(id);
        if (application != null) {
            return ResponseEntity.ok((Object)application);
        }
        return ResponseEntity.notFound().build();
    }

    @RequestMapping(value={"/api/applications/{id}"}, method={RequestMethod.DELETE})
    public ResponseEntity<?> unregister(@PathVariable String id) {
        LOGGER.debug("Unregister application with ID '{}'", (Object)id);
        Application application = this.registry.deregister(id);
        if (application != null) {
            return ResponseEntity.ok((Object)application);
        }
        return ResponseEntity.notFound().build();
    }
}

