/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.notify.filter;

import de.codecentric.boot.admin.event.ClientApplicationEvent;
import de.codecentric.boot.admin.notify.Notifier;
import de.codecentric.boot.admin.notify.filter.ExpiringNotificationFilter;
import de.codecentric.boot.admin.notify.filter.NotificationFilter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilteringNotifier
implements Notifier {
    private static final Logger LOGGER = LoggerFactory.getLogger(FilteringNotifier.class);
    private final ConcurrentMap<String, NotificationFilter> filters = new ConcurrentHashMap<String, NotificationFilter>();
    private final Notifier delegate;
    private long lastCleanup;
    private long cleanupInterval = 10000L;
    private AtomicLong counter = new AtomicLong();

    public FilteringNotifier(Notifier delegate) {
        this.delegate = delegate;
    }

    @Override
    public void notify(ClientApplicationEvent event) {
        if (!this.filter(event)) {
            this.delegate.notify(event);
        }
    }

    private boolean filter(ClientApplicationEvent event) {
        this.cleanUp();
        for (Map.Entry<String, NotificationFilter> entry : this.getNotificationFilters().entrySet()) {
            if (!entry.getValue().filter(event)) continue;
            LOGGER.debug("The event '{}' was suppressed by filter '{}'", (Object)event, entry);
            return true;
        }
        return false;
    }

    private void cleanUp() {
        long now = System.currentTimeMillis();
        if (this.lastCleanup + this.cleanupInterval > now) {
            return;
        }
        this.lastCleanup = now;
        for (Map.Entry<String, NotificationFilter> entry : this.getNotificationFilters().entrySet()) {
            if (!(entry.getValue() instanceof ExpiringNotificationFilter) || !((ExpiringNotificationFilter)entry.getValue()).isExpired()) continue;
            LOGGER.debug("Expired filter '{}' removed", entry);
            this.filters.remove(entry.getKey());
        }
    }

    public String addFilter(NotificationFilter filter) {
        String id = "F" + this.counter.incrementAndGet();
        LOGGER.debug("Added filter '{}' with id '{}'", (Object)filter, (Object)id);
        this.filters.put(id, filter);
        return id;
    }

    public NotificationFilter removeFilter(String id) {
        LOGGER.debug("Removed filter with id '{}'", (Object)id);
        return (NotificationFilter)this.filters.remove(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, NotificationFilter> getNotificationFilters() {
        ConcurrentMap<String, NotificationFilter> concurrentMap = this.filters;
        synchronized (concurrentMap) {
            return Collections.unmodifiableMap(new HashMap<String, NotificationFilter>(this.filters));
        }
    }

    public void setCleanupInterval(long cleanupInterval) {
        this.cleanupInterval = cleanupInterval;
    }
}

