/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.journal.web;

import de.codecentric.boot.admin.event.ClientApplicationEvent;
import de.codecentric.boot.admin.journal.ApplicationEventJournal;
import de.codecentric.boot.admin.web.AdminController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.context.request.async.AsyncRequestTimeoutException;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

@AdminController
@ResponseBody
@RequestMapping(value={"/api/journal"})
public class JournalController {
    private static final Logger LOGGER = LoggerFactory.getLogger(JournalController.class);
    private ApplicationEventJournal eventJournal;
    private final Collection<SseEmitter> emitters = Collections.synchronizedCollection(new LinkedList());

    public JournalController(ApplicationEventJournal eventJournal) {
        this.eventJournal = eventJournal;
    }

    @RequestMapping(produces={"application/json"})
    public Collection<ClientApplicationEvent> getJournal() {
        return this.eventJournal.getEvents();
    }

    @RequestMapping(produces={"text/event-stream"})
    public SseEmitter getJournalEvents() {
        final SseEmitter emitter = new SseEmitter();
        emitter.onCompletion(new Runnable(){

            @Override
            public void run() {
                JournalController.this.emitters.remove(emitter);
            }
        });
        this.emitters.add(emitter);
        return emitter;
    }

    @EventListener
    public void onClientApplicationEvent(ClientApplicationEvent event) {
        for (SseEmitter emitter : new ArrayList<SseEmitter>(this.emitters)) {
            try {
                emitter.send((Object)event, MediaType.APPLICATION_JSON);
            }
            catch (Exception ex) {
                LOGGER.debug("Error sending event to client ", (Throwable)ex);
            }
        }
    }

    @ExceptionHandler(value={AsyncRequestTimeoutException.class})
    public void asyncRequestTimeoutExceptionHandler(HttpServletRequest req) {
        LOGGER.debug("Async request to '{}' timed out", (Object)req.getRequestURI());
    }
}

