/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.discovery;

import com.netflix.appinfo.InstanceInfo;
import de.codecentric.boot.admin.discovery.DefaultServiceInstanceConverter;
import java.net.URI;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.netflix.eureka.EurekaDiscoveryClient;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class EurekaServiceInstanceConverter
extends DefaultServiceInstanceConverter {
    @Override
    protected URI getHealthUrl(ServiceInstance instance) {
        Assert.isInstanceOf(EurekaDiscoveryClient.EurekaServiceInstance.class, (Object)instance, (String)"serviceInstance must be of type EurekaServiceInstance");
        InstanceInfo instanceInfo = ((EurekaDiscoveryClient.EurekaServiceInstance)instance).getInstanceInfo();
        String healthUrl = instanceInfo.getSecureHealthCheckUrl();
        if (StringUtils.isEmpty((Object)healthUrl)) {
            healthUrl = instanceInfo.getHealthCheckUrl();
        }
        return URI.create(healthUrl);
    }
}

