/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class Info
implements Serializable {
    private static final long serialVersionUID = 2L;
    private static Info EMPTY = new Info(0L, null);
    @JsonIgnore
    private final long timestamp;
    private final Map<String, ? extends Serializable> values;

    protected Info(long timestamp, Map<String, ? extends Serializable> values) {
        this.timestamp = timestamp;
        this.values = values != null ? Collections.unmodifiableMap(new LinkedHashMap<String, Serializable>(values)) : Collections.emptyMap();
    }

    public static Info from(Map<String, ? extends Serializable> values) {
        return new Info(System.currentTimeMillis(), values);
    }

    public static Info empty() {
        return EMPTY;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    @JsonAnyGetter
    public Map<String, ? extends Serializable> getValues() {
        return this.values;
    }

    public String toString() {
        return "Info [timestamp=" + this.timestamp + ", values=" + this.values + "]";
    }
}

