/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.zuul.filters.pre;

import com.netflix.zuul.ZuulFilter;
import com.netflix.zuul.context.RequestContext;
import de.codecentric.boot.admin.web.client.HttpHeadersProvider;
import de.codecentric.boot.admin.zuul.ApplicationRouteLocator;
import java.util.List;
import java.util.Map;
import org.springframework.http.HttpHeaders;
import org.springframework.web.util.UrlPathHelper;

public class ApplicationHeadersFilter
extends ZuulFilter {
    private final HttpHeadersProvider headersProvider;
    private final ApplicationRouteLocator routeLocator;
    private final UrlPathHelper urlPathHelper = new UrlPathHelper();

    public ApplicationHeadersFilter(HttpHeadersProvider headersProvider, ApplicationRouteLocator routeLocator) {
        this.headersProvider = headersProvider;
        this.routeLocator = routeLocator;
    }

    public boolean shouldFilter() {
        return true;
    }

    public int filterOrder() {
        return 0;
    }

    public String filterType() {
        return "pre";
    }

    public Object run() {
        RequestContext ctx = RequestContext.getCurrentContext();
        String requestURI = this.urlPathHelper.getPathWithinApplication(ctx.getRequest());
        ApplicationRouteLocator.ApplicationRoute route = this.routeLocator.getMatchingRoute(requestURI);
        if (route != null) {
            HttpHeaders headers = this.headersProvider.getHeaders(route.getApplication());
            for (Map.Entry header : headers.entrySet()) {
                ctx.addZuulRequestHeader((String)header.getKey(), (String)((List)header.getValue()).get(0));
            }
        }
        return null;
    }
}

