/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.config;

import java.util.Arrays;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(value="spring.boot.admin")
public class AdminServerProperties {
    private String contextPath = "";
    private MonitorProperties monitor = new MonitorProperties();
    private RoutesProperties routes = new RoutesProperties();
    private String[] metadataKeysToSanitize = new String[]{".*password$", ".*secret$", ".*key$", ".*$token$", ".*credentials.*", ".*vcap_services$"};

    public void setContextPath(String pathPrefix) {
        if (!pathPrefix.startsWith("/") || pathPrefix.endsWith("/")) {
            throw new IllegalArgumentException("ContextPath must start with '/' and not end with '/'");
        }
        this.contextPath = pathPrefix;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public String[] getMetadataKeysToSanitize() {
        return this.metadataKeysToSanitize;
    }

    public void setMetadataKeysToSanitize(String[] metadataKeysToSanitize) {
        this.metadataKeysToSanitize = metadataKeysToSanitize;
    }

    public MonitorProperties getMonitor() {
        return this.monitor;
    }

    public RoutesProperties getRoutes() {
        return this.routes;
    }

    public static class RoutesProperties {
        private String[] endpoints = new String[]{"env", "metrics", "trace", "dump", "jolokia", "info", "logfile", "refresh", "flyway", "liquibase", "heapdump", "loggers", "auditevents"};

        public String[] getEndpoints() {
            return this.endpoints;
        }

        public void setEndpoints(String[] endpoints) {
            this.endpoints = Arrays.copyOf(endpoints, endpoints.length);
        }
    }

    public static class MonitorProperties {
        private long period = 10000L;
        private long statusLifetime = 10000L;
        private int connectTimeout = 2000;
        private int readTimeout = 5000;

        public void setPeriod(long period) {
            this.period = period;
        }

        public long getPeriod() {
            return this.period;
        }

        public void setStatusLifetime(long statusLifetime) {
            this.statusLifetime = statusLifetime;
        }

        public long getStatusLifetime() {
            return this.statusLifetime;
        }

        public int getConnectTimeout() {
            return this.connectTimeout;
        }

        public void setConnectTimeout(int connectTimeout) {
            this.connectTimeout = connectTimeout;
        }

        public int getReadTimeout() {
            return this.readTimeout;
        }

        public void setReadTimeout(int readTimeout) {
            this.readTimeout = readTimeout;
        }
    }
}

