/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.notify;

import de.codecentric.boot.admin.event.ClientApplicationEvent;
import de.codecentric.boot.admin.notify.AbstractStatusChangeNotifier;
import java.net.URI;
import java.util.HashMap;
import org.springframework.expression.Expression;
import org.springframework.expression.ParserContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.util.Base64Utils;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class LetsChatNotifier
extends AbstractStatusChangeNotifier {
    private static final String DEFAULT_MESSAGE = "*#{application.name}* (#{application.id}) is *#{to.status}*";
    private final SpelExpressionParser parser = new SpelExpressionParser();
    private RestTemplate restTemplate = new RestTemplate();
    private URI url;
    private String room;
    private String token;
    private String username = "Spring Boot Admin";
    private Expression message = this.parser.parseExpression("*#{application.name}* (#{application.id}) is *#{to.status}*", ParserContext.TEMPLATE_EXPRESSION);

    @Override
    protected void doNotify(ClientApplicationEvent event) throws Exception {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        String auth = Base64Utils.encodeToString((byte[])String.format("%s:%s", this.token, this.username).getBytes());
        headers.add("Authorization", String.format("Basic %s", auth));
        this.restTemplate.exchange(this.createUrl(), HttpMethod.POST, new HttpEntity(this.createMessage(event), (MultiValueMap)headers), Void.class);
    }

    private URI createUrl() {
        return URI.create(String.format("%s/rooms/%s/messages", this.url, this.room));
    }

    public void setRestTemplate(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    public void setUrl(URI url) {
        this.url = url;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setRoom(String room) {
        this.room = room;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public void setMessage(String message) {
        this.message = this.parser.parseExpression(message, ParserContext.TEMPLATE_EXPRESSION);
    }

    protected Object createMessage(ClientApplicationEvent event) {
        HashMap<String, String> messageJson = new HashMap<String, String>();
        messageJson.put("text", this.getText(event));
        return messageJson;
    }

    protected String getText(ClientApplicationEvent event) {
        return (String)this.message.getValue((Object)event, String.class);
    }

    public URI getUrl() {
        return this.url;
    }

    public String getRoom() {
        return this.room;
    }

    public String getToken() {
        return this.token;
    }

    public String getUsername() {
        return this.username;
    }

    public String getMessage() {
        return this.message.getExpressionString();
    }
}

