/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.notify;

import de.codecentric.boot.admin.event.ClientApplicationEvent;
import de.codecentric.boot.admin.event.ClientApplicationStatusChangedEvent;
import de.codecentric.boot.admin.notify.AbstractStatusChangeNotifier;
import java.net.URI;
import java.util.HashMap;
import org.springframework.expression.Expression;
import org.springframework.expression.ParserContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class OpsGenieNotifier
extends AbstractStatusChangeNotifier {
    private static final URI DEFAULT_URI = URI.create("https://api.opsgenie.com/v1/json/alert");
    private static final String DEFAULT_MESSAGE = "#{application.name}/#{application.id} is #{to.status}";
    private final SpelExpressionParser parser = new SpelExpressionParser();
    private RestTemplate restTemplate = new RestTemplate();
    private URI url = DEFAULT_URI;
    private String apiKey;
    private String recipients;
    private String actions;
    private String source;
    private String tags;
    private String entity;
    private String user;
    private Expression description = this.parser.parseExpression("#{application.name}/#{application.id} is #{to.status}", ParserContext.TEMPLATE_EXPRESSION);

    @Override
    protected void doNotify(ClientApplicationEvent event) throws Exception {
        this.restTemplate.exchange(this.buildUrl(event), HttpMethod.POST, this.createRequest(event), Void.class, new Object[0]);
    }

    protected String buildUrl(ClientApplicationEvent event) {
        if (event instanceof ClientApplicationStatusChangedEvent && "UP".equals(((ClientApplicationStatusChangedEvent)event).getTo().getStatus())) {
            return String.format("%s/close", this.url.toString());
        }
        return this.url.toString();
    }

    protected HttpEntity createRequest(ClientApplicationEvent event) {
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("apiKey", this.apiKey);
        body.put("message", this.getMessage(event));
        body.put("alias", event.getApplication().getName() + "/" + event.getApplication().getId());
        body.put("description", this.getDescription(event));
        if (event instanceof ClientApplicationStatusChangedEvent && !"UP".equals(((ClientApplicationStatusChangedEvent)event).getTo().getStatus())) {
            if (this.recipients != null) {
                body.put("recipients", this.recipients);
            }
            if (this.actions != null) {
                body.put("actions", this.actions);
            }
            if (this.source != null) {
                body.put("source", this.source);
            }
            if (this.tags != null) {
                body.put("tags", this.tags);
            }
            if (this.entity != null) {
                body.put("entity", this.entity);
            }
            if (this.user != null) {
                body.put("user", this.user);
            }
            HashMap<String, String> details = new HashMap<String, String>();
            details.put("type", "link");
            details.put("href", event.getApplication().getHealthUrl());
            details.put("text", "Application health-endpoint");
            body.put("details", details);
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        return new HttpEntity(body, (MultiValueMap)headers);
    }

    protected String getMessage(ClientApplicationEvent event) {
        return (String)this.description.getValue((Object)event, String.class);
    }

    protected String getDescription(ClientApplicationEvent event) {
        return String.format("Application %s (%s) went from %s to %s", event.getApplication().getName(), event.getApplication().getId(), ((ClientApplicationStatusChangedEvent)event).getFrom().getStatus(), ((ClientApplicationStatusChangedEvent)event).getTo().getStatus());
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public void setDescription(String description) {
        this.description = this.parser.parseExpression(description, ParserContext.TEMPLATE_EXPRESSION);
    }

    public String getMessage() {
        return this.description.getExpressionString();
    }

    public void setRestTemplate(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    public String getRecipients() {
        return this.recipients;
    }

    public void setRecipients(String recipients) {
        this.recipients = recipients;
    }

    public String getActions() {
        return this.actions;
    }

    public void setActions(String actions) {
        this.actions = actions;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getTags() {
        return this.tags;
    }

    public void setTags(String tags) {
        this.tags = tags;
    }

    public String getEntity() {
        return this.entity;
    }

    public void setEntity(String entity) {
        this.entity = entity;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }
}

