/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.server.services;

import de.codecentric.boot.admin.server.domain.events.InstanceEvent;
import de.codecentric.boot.admin.server.domain.events.InstanceRegistrationUpdatedEvent;
import de.codecentric.boot.admin.server.domain.events.InstanceStatusChangedEvent;
import de.codecentric.boot.admin.server.services.EndpointDetector;
import de.codecentric.boot.admin.server.services.ResubscribingEventHandler;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class EndpointDetectionTrigger
extends ResubscribingEventHandler<InstanceEvent> {
    private final EndpointDetector endpointDetector;

    public EndpointDetectionTrigger(EndpointDetector endpointDetector, Publisher<InstanceEvent> publisher) {
        super(publisher, InstanceEvent.class);
        this.endpointDetector = endpointDetector;
    }

    @Override
    protected Publisher<?> handle(Flux<InstanceEvent> publisher) {
        return publisher.subscribeOn(Schedulers.newSingle((String)"endpoint-detector")).filter(event -> event instanceof InstanceStatusChangedEvent || event instanceof InstanceRegistrationUpdatedEvent).flatMap(this::detectEndpoints);
    }

    protected Mono<Void> detectEndpoints(InstanceEvent event) {
        return this.endpointDetector.detectEndpoints(event.getInstance());
    }
}

