/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.server.services;

import de.codecentric.boot.admin.server.domain.entities.Instance;
import de.codecentric.boot.admin.server.domain.entities.InstanceRepository;
import de.codecentric.boot.admin.server.domain.values.InstanceId;
import de.codecentric.boot.admin.server.services.endpoints.EndpointDetectionStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Mono;

public class EndpointDetector {
    private static final Logger log = LoggerFactory.getLogger(EndpointDetector.class);
    private final InstanceRepository repository;
    private final EndpointDetectionStrategy strategy;

    public EndpointDetector(InstanceRepository repository, EndpointDetectionStrategy strategy) {
        this.repository = repository;
        this.strategy = strategy;
    }

    public Mono<Void> detectEndpoints(InstanceId id) {
        return this.repository.computeIfPresent(id, (key, instance) -> this.doDetectEndpoints((Instance)instance)).then();
    }

    private Mono<Instance> doDetectEndpoints(Instance instance) {
        if (!StringUtils.hasText((String)instance.getRegistration().getManagementUrl()) || instance.getStatusInfo().isOffline() || instance.getStatusInfo().isUnknown()) {
            return Mono.empty();
        }
        log.debug("Detect endpoints for {}", (Object)instance);
        return this.strategy.detectEndpoints(instance).map(instance::withEndpoints);
    }
}

