/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.server.web.client;

import de.codecentric.boot.admin.server.domain.entities.Instance;
import de.codecentric.boot.admin.server.web.client.HttpHeadersProvider;
import de.codecentric.boot.admin.server.web.client.InstanceExchangeFilterFunctions;
import de.codecentric.boot.admin.server.web.client.LegacyEndpointConverters;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.handler.timeout.ReadTimeoutHandler;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.springframework.boot.web.reactive.function.client.WebClientCustomizer;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.ReactorClientHttpConnector;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;
import reactor.ipc.netty.http.client.HttpClientOptions;

public class InstanceWebClient {
    private final WebClient webClient;

    public InstanceWebClient(HttpHeadersProvider httpHeadersProvider) {
        this(httpHeadersProvider, Duration.ofSeconds(2L), Duration.ofSeconds(5L));
    }

    public InstanceWebClient(HttpHeadersProvider httpHeadersProvider, Duration connectTimeout, Duration readTimeout) {
        this(httpHeadersProvider, connectTimeout, readTimeout, builder -> {});
    }

    public InstanceWebClient(HttpHeadersProvider httpHeadersProvider, Duration connectTimeout, Duration readTimeout, WebClientCustomizer customizer) {
        this(InstanceWebClient.createDefaultWebClient(connectTimeout, readTimeout, customizer), httpHeadersProvider);
    }

    public InstanceWebClient(WebClient webClient, HttpHeadersProvider httpHeadersProvider) {
        this.webClient = webClient.mutate().filters(filters -> {
            filters.add(InstanceExchangeFilterFunctions.addHeaders(httpHeadersProvider));
            filters.add(InstanceExchangeFilterFunctions.rewriteEndpointUrl());
            filters.add(InstanceExchangeFilterFunctions.setDefaultAcceptHeader());
            filters.add(InstanceExchangeFilterFunctions.convertLegacyEndpoint(LegacyEndpointConverters.health()));
            filters.add(InstanceExchangeFilterFunctions.convertLegacyEndpoint(LegacyEndpointConverters.info()));
            filters.add(InstanceExchangeFilterFunctions.convertLegacyEndpoint(LegacyEndpointConverters.env()));
            filters.add(InstanceExchangeFilterFunctions.convertLegacyEndpoint(LegacyEndpointConverters.httptrace()));
            filters.add(InstanceExchangeFilterFunctions.convertLegacyEndpoint(LegacyEndpointConverters.threaddump()));
            filters.add(InstanceExchangeFilterFunctions.convertLegacyEndpoint(LegacyEndpointConverters.liquibase()));
            filters.add(InstanceExchangeFilterFunctions.convertLegacyEndpoint(LegacyEndpointConverters.flyway()));
        }).build();
    }

    public WebClient instance(Mono<Instance> instance) {
        return this.webClient.mutate().filters(filters -> filters.add(0, InstanceExchangeFilterFunctions.setInstance(instance))).build();
    }

    public WebClient instance(Instance instance) {
        return this.webClient.mutate().filters(filters -> filters.add(0, InstanceExchangeFilterFunctions.setInstance(instance))).build();
    }

    private static WebClient createDefaultWebClient(Duration connectTimeout, Duration readTimeout, WebClientCustomizer customizer) {
        ReactorClientHttpConnector connector = new ReactorClientHttpConnector(options -> {
            HttpClientOptions.Builder cfr_ignored_0 = (HttpClientOptions.Builder)((HttpClientOptions.Builder)options.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)((int)connectTimeout.toMillis()))).compression(true).afterNettyContextInit(ctx -> ctx.addHandlerLast((ChannelHandler)new ReadTimeoutHandler(readTimeout.toMillis(), TimeUnit.MILLISECONDS)));
        });
        WebClient.Builder builder = WebClient.builder().clientConnector((ClientHttpConnector)connector);
        customizer.customize(builder);
        return builder.build();
    }
}

