/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.server.services;

import de.codecentric.boot.admin.server.domain.events.InstanceEvent;
import de.codecentric.boot.admin.server.domain.events.InstanceRegistrationUpdatedEvent;
import de.codecentric.boot.admin.server.domain.events.InstanceStatusChangedEvent;
import de.codecentric.boot.admin.server.services.AbstractEventHandler;
import de.codecentric.boot.admin.server.services.EndpointDetector;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

public class EndpointDetectionTrigger
extends AbstractEventHandler<InstanceEvent> {
    private final EndpointDetector endpointDetector;

    public EndpointDetectionTrigger(EndpointDetector endpointDetector, Publisher<InstanceEvent> publisher) {
        super(publisher, InstanceEvent.class);
        this.endpointDetector = endpointDetector;
    }

    @Override
    protected Publisher<Void> handle(Flux<InstanceEvent> publisher) {
        Scheduler scheduler = Schedulers.newSingle((String)"endpoint-detector");
        return publisher.subscribeOn(scheduler).filter(event -> event instanceof InstanceStatusChangedEvent || event instanceof InstanceRegistrationUpdatedEvent).flatMap(this::detectEndpoints).doFinally(s -> scheduler.dispose());
    }

    protected Mono<Void> detectEndpoints(InstanceEvent event) {
        return this.endpointDetector.detectEndpoints(event.getInstance());
    }
}

