/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.server.eventstore;

import de.codecentric.boot.admin.server.domain.events.InstanceEvent;
import java.util.List;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;
import reactor.core.publisher.UnicastProcessor;

public class InstanceEventPublisher
implements Publisher<InstanceEvent> {
    private static final Logger log = LoggerFactory.getLogger(InstanceEventPublisher.class);
    private final Flux<InstanceEvent> publishedFlux;
    private final FluxSink<InstanceEvent> sink;

    protected InstanceEventPublisher() {
        UnicastProcessor unicastProcessor = UnicastProcessor.create();
        this.publishedFlux = unicastProcessor.publish().autoConnect(0);
        this.sink = unicastProcessor.sink();
    }

    protected void publish(List<InstanceEvent> events) {
        events.forEach(event -> {
            log.debug("Event published {}", event);
            this.sink.next(event);
        });
    }

    public void subscribe(Subscriber<? super InstanceEvent> s) {
        this.publishedFlux.subscribe(s);
    }
}

