/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.server.web.servlet;

import de.codecentric.boot.admin.server.services.InstanceRegistry;
import de.codecentric.boot.admin.server.web.AbstractInstancesProxyController;
import de.codecentric.boot.admin.server.web.AdminController;
import de.codecentric.boot.admin.server.web.client.InstanceWebClient;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.reactivestreams.Publisher;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.core.io.buffer.DefaultDataBufferFactory;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.http.server.ServletServerHttpResponse;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.reactive.function.BodyExtractors;
import org.springframework.web.reactive.function.BodyInserter;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@AdminController
public class InstancesProxyController
extends AbstractInstancesProxyController {
    private final DataBufferFactory bufferFactory = new DefaultDataBufferFactory();

    public InstancesProxyController(String adminContextPath, Set<String> ignoredHeaders, InstanceRegistry registry, InstanceWebClient instanceWebClient) {
        super(adminContextPath, ignoredHeaders, registry, instanceWebClient);
    }

    @ResponseBody
    @RequestMapping(path={"/instances/{instanceId}/actuator/**"}, method={RequestMethod.GET, RequestMethod.HEAD, RequestMethod.POST, RequestMethod.PUT, RequestMethod.PATCH, RequestMethod.DELETE, RequestMethod.OPTIONS})
    public Mono<Void> endpointProxy(@PathVariable(value="instanceId") String instanceId, HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws IOException {
        ServletServerHttpRequest request = new ServletServerHttpRequest(servletRequest);
        String pathWithinApplication = UriComponentsBuilder.fromPath((String)servletRequest.getAttribute(HandlerMapping.PATH_WITHIN_HANDLER_MAPPING_ATTRIBUTE).toString()).toUriString();
        String endpointLocalPath = this.getEndpointLocalPath(pathWithinApplication);
        URI uri = UriComponentsBuilder.fromPath((String)endpointLocalPath).query(request.getURI().getRawQuery()).build(true).toUri();
        ClientResponse clientResponse = (ClientResponse)super.forward(instanceId, uri, request.getMethod(), request.getHeaders(), () -> this.lambda$endpointProxy$0((ServerHttpRequest)request)).block();
        ServletServerHttpResponse response = new ServletServerHttpResponse(servletResponse);
        response.setStatusCode(clientResponse.statusCode());
        response.getHeaders().addAll((MultiValueMap)this.filterHeaders(clientResponse.headers().asHttpHeaders()));
        OutputStream responseBody = response.getBody();
        response.flush();
        return ((Flux)clientResponse.body(BodyExtractors.toDataBuffers())).window(1).concatMap(body -> this.writeAndFlush((Flux<DataBuffer>)body, responseBody)).then();
    }

    private Mono<Void> writeAndFlush(Flux<DataBuffer> body, OutputStream responseBody) {
        return DataBufferUtils.write(body, (OutputStream)responseBody).map(DataBufferUtils::release).then(Mono.create(sink -> {
            try {
                responseBody.flush();
                sink.success();
            }
            catch (IOException ex) {
                sink.error((Throwable)ex);
            }
        }));
    }

    private /* synthetic */ BodyInserter lambda$endpointProxy$0(ServerHttpRequest request) {
        return BodyInserters.fromDataBuffers((Publisher)DataBufferUtils.readInputStream(() -> ((ServerHttpRequest)request).getBody(), (DataBufferFactory)this.bufferFactory, (int)4096));
    }
}

