/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.server.domain.events;

import de.codecentric.boot.admin.server.domain.values.InstanceId;
import java.io.Serializable;
import java.time.Instant;
import lombok.Generated;
import org.springframework.util.Assert;

public abstract class InstanceEvent
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final InstanceId instance;
    private final long version;
    private final Instant timestamp;
    private final String type;

    protected InstanceEvent(InstanceId instance, long version, String type, Instant timestamp) {
        Assert.notNull((Object)instance, (String)"'instance' must not be null");
        Assert.notNull((Object)timestamp, (String)"'timestamp' must not be null");
        Assert.hasText((String)type, (String)"'type' must not be empty");
        this.instance = instance;
        this.version = version;
        this.timestamp = timestamp;
        this.type = type;
    }

    @Generated
    public InstanceId getInstance() {
        return this.instance;
    }

    @Generated
    public long getVersion() {
        return this.version;
    }

    @Generated
    public Instant getTimestamp() {
        return this.timestamp;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InstanceEvent)) {
            return false;
        }
        InstanceEvent other = (InstanceEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getVersion() != other.getVersion()) {
            return false;
        }
        InstanceId this$instance = this.getInstance();
        InstanceId other$instance = other.getInstance();
        if (this$instance == null ? other$instance != null : !((Object)this$instance).equals(other$instance)) {
            return false;
        }
        Instant this$timestamp = this.getTimestamp();
        Instant other$timestamp = other.getTimestamp();
        if (this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        return !(this$type == null ? other$type != null : !this$type.equals(other$type));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof InstanceEvent;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $version = this.getVersion();
        result = result * 59 + (int)($version >>> 32 ^ $version);
        InstanceId $instance = this.getInstance();
        result = result * 59 + ($instance == null ? 43 : ((Object)$instance).hashCode());
        Instant $timestamp = this.getTimestamp();
        result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "InstanceEvent(instance=" + this.getInstance() + ", version=" + this.getVersion() + ", timestamp=" + this.getTimestamp() + ", type=" + this.getType() + ")";
    }
}

