/*
 * Decompiled with CFR 0.152.
 */
package de.larmic.butterfaces.component.partrenderer;

import de.larmic.butterfaces.component.html.HtmlCheckBox;
import de.larmic.butterfaces.component.html.HtmlComboBox;
import de.larmic.butterfaces.component.html.HtmlInputComponent;
import de.larmic.butterfaces.component.partrenderer.StringUtils;
import java.io.IOException;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UISelectItem;
import javax.faces.component.UISelectItems;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.model.SelectItem;

public class ReadonlyPartRenderer {
    public void renderReadonly(HtmlInputComponent component, ResponseWriter writer) throws IOException {
        UIInput uiComponent = (UIInput)component;
        boolean readonly = component.isReadonly();
        Object value = component.getValue();
        if (readonly) {
            writer.startElement("div", (UIComponent)uiComponent);
            StringBuilder sb = new StringBuilder("butter-component-value butter-component-value-readonly");
            if (component.isHideLabel()) {
                sb.append(" butter-component-value-hiddenLabel");
            }
            writer.writeAttribute("class", (Object)sb.toString(), null);
            writer.startElement("span", (UIComponent)uiComponent);
            writer.writeAttribute("class", (Object)"butter-component-value-readonly-wrapper", "styleClass");
            writer.writeText((Object)this.getReadonlyDisplayValue(value, uiComponent, uiComponent.getConverter()), null);
            writer.endElement("span");
            writer.endElement("div");
        }
    }

    private String getReadonlyDisplayValue(Object value, UIInput component, Converter converter) {
        if (value == null || "".equals(value)) {
            return "-";
        }
        if (converter != null) {
            String asString = converter.getAsString(FacesContext.getCurrentInstance(), (UIComponent)component, value);
            return asString == null ? "-" : asString;
        }
        if (component instanceof HtmlCheckBox) {
            HtmlCheckBox checkBoxComponent = (HtmlCheckBox)component;
            StringBuilder sb = new StringBuilder();
            if (StringUtils.isNotEmpty(checkBoxComponent.getDescription())) {
                sb.append(checkBoxComponent.getDescription()).append(": ");
            }
            sb.append((Boolean)value != false ? "ja" : "nein");
            return sb.toString();
        }
        if (component instanceof HtmlComboBox) {
            return this.getReadableValueFrom((HtmlComboBox)component, value);
        }
        return String.valueOf(value);
    }

    private String getReadableValueFrom(HtmlComboBox comboBox, Object value) {
        for (UIComponent child : comboBox.getChildren()) {
            UISelectItem item;
            if (child instanceof UISelectItems) {
                List items = (List)((UISelectItems)child).getValue();
                for (SelectItem item2 : items) {
                    if (!this.isMatchingLabel(item2, value)) continue;
                    return item2.getLabel();
                }
                continue;
            }
            if (!(child instanceof UISelectItem) || !this.isMatchingLabel(item = (UISelectItem)child, value)) continue;
            return item.getItemLabel();
        }
        return String.valueOf(value);
    }

    private boolean isMatchingLabel(SelectItem item, Object value) {
        return value.equals(item.getValue());
    }

    private boolean isMatchingLabel(UISelectItem item, Object value) {
        return value.equals(item.getValue());
    }
}

