/*
 * Decompiled with CFR 0.152.
 */
package de.larmic.butterfaces.component.renderkit.html_basic;

import de.larmic.butterfaces.component.base.renderer.HtmlBasicRenderer;
import de.larmic.butterfaces.component.html.HtmlSection;
import de.larmic.butterfaces.component.partrenderer.StringUtils;
import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.FacesRenderer;

@FacesRenderer(componentFamily="de.larmic.butterfaces.component.family", rendererType="de.larmic.butterfaces.renderkit.html_basic.SectionRenderer")
public class SectionRenderer
extends HtmlBasicRenderer {
    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        this.rendererParamsNotNull(context, component);
        if (!this.shouldEncode(component)) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        HtmlSection fieldSet = (HtmlSection)component;
        String style = fieldSet.getStyle();
        String styleClass = fieldSet.getStyleClass();
        writer.startElement("section", component);
        this.writeIdAttribute(context, writer, component);
        if (null != style) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        if (null != styleClass) {
            writer.writeAttribute("class", (Object)("butter-component-section " + styleClass), "styleClass");
        } else {
            writer.writeAttribute("class", (Object)"butter-component-section", "styleClass");
        }
        this.encodeHeader(component, writer, fieldSet);
        writer.startElement("div", component);
        writer.writeAttribute("class", (Object)"butter-component-section-content", null);
    }

    private void encodeHeader(UIComponent component, ResponseWriter writer, HtmlSection section) throws IOException {
        UIComponent additionalHeader = this.getFacet(component, "additional-header");
        boolean labelNotEmpty = StringUtils.isNotEmpty(section.getLabel());
        if (labelNotEmpty) {
            writer.startElement("div", component);
            writer.writeAttribute("class", (Object)"butter-component-section-title", null);
            writer.writeText((Object)section.getLabel(), component, "label");
            if (StringUtils.isNotEmpty(section.getBadgeText())) {
                writer.startElement("span", component);
                writer.writeAttribute("class", (Object)"badge", null);
                writer.writeText((Object)section.getBadgeText(), component, "badgeText");
                writer.endElement("span");
            }
            if (additionalHeader != null) {
                writer.startElement("span", component);
                writer.writeAttribute("class", (Object)"butter-component-section-additional-header", null);
                additionalHeader.encodeAll(FacesContext.getCurrentInstance());
                writer.endElement("span");
            }
            writer.endElement("div");
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        this.rendererParamsNotNull(context, component);
        if (!this.shouldEncode(component)) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        writer.endElement("div");
        writer.endElement("section");
    }
}

