/*
 * Decompiled with CFR 0.152.
 */
package de.larmic.butterfaces.component.renderkit.html_basic.ajax;

import de.larmic.butterfaces.component.base.renderer.HtmlBasicRenderer;
import de.larmic.butterfaces.component.html.ajax.WaitingPanel;
import de.larmic.butterfaces.component.partrenderer.RenderUtils;
import de.larmic.butterfaces.component.partrenderer.StringUtils;
import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.FacesRenderer;

@FacesRenderer(componentFamily="de.larmic.butterfaces.component.family", rendererType="de.larmic.butterfaces.renderkit.html_basic.WaitingPanelRenderer")
public class WaitingPanelRenderer
extends HtmlBasicRenderer {
    public static final int DEFAULT_WAITING_PANEL_DELAY = 500;

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        this.rendererParamsNotNull(context, component);
        if (!this.shouldEncode(component)) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        WaitingPanel waitingPanel = (WaitingPanel)component;
        String style = waitingPanel.getStyle();
        String styleClass = waitingPanel.getStyleClass();
        writer.startElement("div", component);
        this.writeIdAttribute(context, writer, component);
        if (StringUtils.isNotEmpty(style)) {
            writer.writeAttribute("style", (Object)style, null);
        }
        if (StringUtils.isNotEmpty(styleClass)) {
            writer.writeAttribute("class", (Object)("butter-component-waitingPanel " + styleClass), null);
        } else {
            writer.writeAttribute("class", (Object)"butter-component-waitingPanel", null);
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        this.rendererParamsNotNull(context, component);
        if (!this.shouldEncode(component)) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        WaitingPanel waitingPanel = (WaitingPanel)component;
        writer.endElement("div");
        String pluginFunctionCall = "waitingPanel(" + this.createButterTreeJQueryParameter(waitingPanel) + ")";
        RenderUtils.renderJQueryPluginCall(component.getClientId(), pluginFunctionCall, writer, component);
    }

    private String createButterTreeJQueryParameter(WaitingPanel waitingPanel) {
        int waitingPanelDelay = this.getWaitingPanelDelay(waitingPanel);
        return "{waitingPanelDelay: '" + waitingPanelDelay + "', blockpage: " + waitingPanel.isBlockpage() + "}";
    }

    private int getWaitingPanelDelay(WaitingPanel waitingPanel) {
        if (waitingPanel.getDelay() != null) {
            return waitingPanel.getDelay() > 0 ? waitingPanel.getDelay() : 0;
        }
        return 500;
    }
}

