/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.inspection;

import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInspection.BaseJavaLocalInspectionTool;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReferenceExpression;
import de.plushnikov.intellij.lombok.problem.LombokProblem;
import de.plushnikov.intellij.lombok.processor.LombokProcessor;
import de.plushnikov.intellij.plugin.core.GenericServiceLocator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class LombokInspection
extends BaseJavaLocalInspectionTool {
    private static final Logger LOG = Logger.getInstance((String)LombokInspection.class.getName());
    private final Map<String, Collection<LombokProcessor>> allProblemHandlers = new HashMap<String, Collection<LombokProcessor>>();

    public LombokInspection() {
        List<LombokProcessor> list = GenericServiceLocator.locateAll(LombokProcessor.class);
        for (LombokProcessor lombokProcessor : list) {
            Collection<LombokProcessor> collection = this.allProblemHandlers.get(lombokProcessor.getSupportedAnnotation());
            if (null == collection) {
                collection = new ArrayList<LombokProcessor>(2);
                this.allProblemHandlers.put(lombokProcessor.getSupportedAnnotation(), collection);
            }
            collection.add(lombokProcessor);
        }
    }

    @NotNull
    public String getDisplayName() {
        return "Lombok annotations inspection";
    }

    @NotNull
    public String getGroupDisplayName() {
        return GroupNames.BUGS_GROUP_NAME;
    }

    @NotNull
    public String getShortName() {
        return "Lombok";
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder problemsHolder, boolean bl) {
        return new JavaElementVisitor(){

            public void visitReferenceExpression(PsiReferenceExpression psiReferenceExpression) {
            }

            public void visitAnnotation(PsiAnnotation psiAnnotation) {
                super.visitAnnotation(psiAnnotation);
                String string = psiAnnotation.getQualifiedName();
                if (null != string && LombokInspection.this.allProblemHandlers.containsKey(string)) {
                    for (LombokProcessor lombokProcessor : (Collection)LombokInspection.this.allProblemHandlers.get(string)) {
                        Collection collection = lombokProcessor.verifyAnnotation(psiAnnotation);
                        for (LombokProblem lombokProblem : collection) {
                            problemsHolder.registerProblem((PsiElement)psiAnnotation, lombokProblem.getMessage(), lombokProblem.getHighlightType(), lombokProblem.getQuickFixes());
                        }
                    }
                }
            }
        };
    }
}

