/*
 * Decompiled with CFR 0.152.
 */
package de.felixroske.jfxsupport;

import de.felixroske.jfxsupport.AbstractFxmlView;
import de.felixroske.jfxsupport.GUIState;
import de.felixroske.jfxsupport.PropertyReaderHelper;
import de.felixroske.jfxsupport.SplashScreen;
import java.awt.SystemTray;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javafx.application.Application;
import javafx.application.HostServices;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.image.Image;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.Environment;

public abstract class AbstractJavaFxApplicationSupport
extends Application {
    private static Logger LOGGER = LoggerFactory.getLogger(AbstractJavaFxApplicationSupport.class);
    private static String[] savedArgs = new String[0];
    static Class<? extends AbstractFxmlView> savedInitialView;
    static SplashScreen splashScreen;
    private static ConfigurableApplicationContext applicationContext;
    private static List<Image> icons;
    private final List<Image> defaultIcons = new ArrayList<Image>();
    private final BooleanProperty appCtxLoaded = new SimpleBooleanProperty(false);

    public static Stage getStage() {
        return GUIState.getStage();
    }

    public static Scene getScene() {
        return GUIState.getScene();
    }

    public static HostServices getAppHostServices() {
        return GUIState.getHostServices();
    }

    public static SystemTray getSystemTray() {
        return GUIState.getSystemTray();
    }

    public static void showView(Class<? extends AbstractFxmlView> window, Modality mode) {
        AbstractFxmlView view = (AbstractFxmlView)applicationContext.getBean(window);
        Stage newStage = new Stage();
        Scene newScene = view.getView().getScene() != null ? view.getView().getScene() : new Scene(view.getView());
        newStage.setScene(newScene);
        newStage.initModality(mode);
        newStage.initOwner((Window)AbstractJavaFxApplicationSupport.getStage());
        newStage.setTitle(view.getDefaultTitle());
        newStage.initStyle(view.getDefaultStyle());
        newStage.showAndWait();
    }

    private void loadIcons(ConfigurableApplicationContext ctx) {
        try {
            List<String> fsImages = PropertyReaderHelper.get((Environment)ctx.getEnvironment(), "javafx.appicons");
            if (!fsImages.isEmpty()) {
                fsImages.forEach(s -> {
                    Image img = new Image(((Object)((Object)this)).getClass().getResource((String)s).toExternalForm());
                    icons.add(img);
                });
            } else {
                icons.addAll(this.defaultIcons);
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to load icons: ", (Throwable)e);
        }
    }

    public void init() throws Exception {
        this.defaultIcons.addAll(this.loadDefaultIcons());
        CompletableFuture.supplyAsync(() -> SpringApplication.run(((Object)((Object)this)).getClass(), (String[])savedArgs)).whenComplete((ctx, throwable) -> {
            if (throwable != null) {
                LOGGER.error("Failed to load spring application context: ", throwable);
                Platform.runLater(() -> AbstractJavaFxApplicationSupport.showErrorAlert(throwable));
            } else {
                Platform.runLater(() -> {
                    this.loadIcons((ConfigurableApplicationContext)ctx);
                    this.launchApplicationView((ConfigurableApplicationContext)ctx);
                });
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(Stage stage) throws Exception {
        GUIState.setStage(stage);
        GUIState.setHostServices(this.getHostServices());
        Stage splashStage = new Stage(StageStyle.TRANSPARENT);
        if (splashScreen.visible()) {
            Scene splashScene = new Scene(splashScreen.getParent(), (Paint)Color.TRANSPARENT);
            splashStage.setScene(splashScene);
            splashStage.getIcons().addAll(this.defaultIcons);
            splashStage.initStyle(StageStyle.TRANSPARENT);
            this.beforeShowingSplash(splashStage);
            splashStage.show();
        }
        Runnable showMainAndCloseSplash = () -> {
            this.showInitialView();
            if (splashScreen.visible()) {
                splashStage.hide();
                splashStage.setScene(null);
            }
        };
        AbstractJavaFxApplicationSupport abstractJavaFxApplicationSupport = this;
        synchronized (abstractJavaFxApplicationSupport) {
            if (this.appCtxLoaded.get()) {
                Platform.runLater((Runnable)showMainAndCloseSplash);
            } else {
                this.appCtxLoaded.addListener((ov, oVal, nVal) -> Platform.runLater((Runnable)showMainAndCloseSplash));
            }
        }
    }

    private void showInitialView() {
        String stageStyle = applicationContext.getEnvironment().getProperty("javafx.stage.style");
        if (stageStyle != null) {
            GUIState.getStage().initStyle(StageStyle.valueOf((String)stageStyle.toUpperCase()));
        } else {
            GUIState.getStage().initStyle(StageStyle.DECORATED);
        }
        this.beforeInitialView(GUIState.getStage(), applicationContext);
        AbstractJavaFxApplicationSupport.showView(savedInitialView);
    }

    private void launchApplicationView(ConfigurableApplicationContext ctx) {
        applicationContext = ctx;
        this.appCtxLoaded.set(true);
    }

    public static void showView(Class<? extends AbstractFxmlView> newView) {
        try {
            AbstractFxmlView view = (AbstractFxmlView)applicationContext.getBean(newView);
            if (GUIState.getScene() == null) {
                GUIState.setScene(new Scene(view.getView()));
            } else {
                GUIState.getScene().setRoot(view.getView());
            }
            GUIState.getStage().setScene(GUIState.getScene());
            AbstractJavaFxApplicationSupport.applyEnvPropsToView();
            GUIState.getStage().getIcons().addAll(icons);
            GUIState.getStage().show();
        }
        catch (Throwable t) {
            LOGGER.error("Failed to load application: ", t);
            AbstractJavaFxApplicationSupport.showErrorAlert(t);
        }
    }

    private static void showErrorAlert(Throwable throwable) {
        Alert alert = new Alert(Alert.AlertType.ERROR, "Oops! An unrecoverable error occurred.\nPlease contact your software vendor.\n\nThe application will stop now.", new ButtonType[0]);
        alert.showAndWait().ifPresent(response -> Platform.exit());
    }

    private static void applyEnvPropsToView() {
        PropertyReaderHelper.setIfPresent((Environment)applicationContext.getEnvironment(), "javafx.title", String.class, arg_0 -> ((Stage)GUIState.getStage()).setTitle(arg_0));
        PropertyReaderHelper.setIfPresent((Environment)applicationContext.getEnvironment(), "javafx.stage.width", Double.class, arg_0 -> ((Stage)GUIState.getStage()).setWidth(arg_0));
        PropertyReaderHelper.setIfPresent((Environment)applicationContext.getEnvironment(), "javafx.stage.height", Double.class, arg_0 -> ((Stage)GUIState.getStage()).setHeight(arg_0));
        PropertyReaderHelper.setIfPresent((Environment)applicationContext.getEnvironment(), "javafx.stage.resizable", Boolean.class, arg_0 -> ((Stage)GUIState.getStage()).setResizable(arg_0));
    }

    public void stop() throws Exception {
        super.stop();
        if (applicationContext != null) {
            applicationContext.close();
        }
    }

    protected static void setTitle(String title) {
        GUIState.getStage().setTitle(title);
    }

    public static void launch(Class<? extends Application> appClass, Class<? extends AbstractFxmlView> view, String[] args) {
        AbstractJavaFxApplicationSupport.launch(appClass, view, new SplashScreen(), args);
    }

    @Deprecated
    public static void launchApp(Class<? extends Application> appClass, Class<? extends AbstractFxmlView> view, String[] args) {
        AbstractJavaFxApplicationSupport.launch(appClass, view, new SplashScreen(), args);
    }

    public static void launch(Class<? extends Application> appClass, Class<? extends AbstractFxmlView> view, SplashScreen splashScreen, String[] args) {
        savedInitialView = view;
        savedArgs = args;
        AbstractJavaFxApplicationSupport.splashScreen = splashScreen != null ? splashScreen : new SplashScreen();
        if (SystemTray.isSupported()) {
            GUIState.setSystemTray(SystemTray.getSystemTray());
        }
        Application.launch(appClass, (String[])args);
    }

    @Deprecated
    public static void launchApp(Class<? extends Application> appClass, Class<? extends AbstractFxmlView> view, SplashScreen splashScreen, String[] args) {
        AbstractJavaFxApplicationSupport.launch(appClass, view, splashScreen, args);
    }

    public void beforeInitialView(Stage stage, ConfigurableApplicationContext ctx) {
    }

    public void beforeShowingSplash(Stage splashStage) {
    }

    public Collection<Image> loadDefaultIcons() {
        return Arrays.asList(new Image(((Object)((Object)this)).getClass().getResource("/icons/gear_16x16.png").toExternalForm()), new Image(((Object)((Object)this)).getClass().getResource("/icons/gear_24x24.png").toExternalForm()), new Image(((Object)((Object)this)).getClass().getResource("/icons/gear_36x36.png").toExternalForm()), new Image(((Object)((Object)this)).getClass().getResource("/icons/gear_42x42.png").toExternalForm()), new Image(((Object)((Object)this)).getClass().getResource("/icons/gear_64x64.png").toExternalForm()));
    }

    static {
        icons = new ArrayList<Image>();
    }
}

