/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.bson4jackson.deserializers;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.node.ValueNode;
import de.undercouch.bson4jackson.BsonParser;
import de.undercouch.bson4jackson.types.Timestamp;
import java.io.IOException;

public class BsonTimestampDeserializer
extends JsonDeserializer<Timestamp> {
    public Timestamp deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        if (jp instanceof BsonParser) {
            BsonParser bsonParser = (BsonParser)jp;
            if (bsonParser.getCurrentToken() != JsonToken.VALUE_EMBEDDED_OBJECT || bsonParser.getCurrentBsonType() != 17) {
                throw ctxt.mappingException(Timestamp.class);
            }
            return (Timestamp)bsonParser.getEmbeddedObject();
        }
        if (jp.getCurrentToken() == JsonToken.VALUE_EMBEDDED_OBJECT && jp.getEmbeddedObject() instanceof Timestamp) {
            return (Timestamp)jp.getEmbeddedObject();
        }
        TreeNode tree = jp.getCodec().readTree(jp);
        int time = ((ValueNode)tree.get("$time")).asInt();
        int inc = ((ValueNode)tree.get("$inc")).asInt();
        return new Timestamp(time, inc);
    }
}

