/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.gemfire.testcontainers;

import com.github.dockerjava.api.command.InspectContainerResponse;
import com.vmware.gemfire.testcontainers.MemberConfig;
import java.util.ArrayList;
import java.util.List;
import org.testcontainers.containers.SocatContainer;
import org.testcontainers.images.builder.Transferable;

public class GemFireProxyContainer
extends SocatContainer {
    private static final String STARTER_SCRIPT = "/gemfire_proxy_start.sh";
    private static final int BASE_PORT = 2000;
    private final List<MemberConfig> serverConfigs;
    private final List<MemberConfig> locatorConfigs;

    public GemFireProxyContainer(List<MemberConfig> locatorConfigs, List<MemberConfig> serverConfigs) {
        int i;
        this.locatorConfigs = locatorConfigs;
        this.serverConfigs = serverConfigs;
        int port = 2000;
        for (i = 0; i < locatorConfigs.size(); ++i) {
            this.addExposedPort(port);
            locatorConfigs.get(i).setProxyListenPort(port);
            this.addExposedPort(++port);
            locatorConfigs.get(i).setProxyHttpListenPort(port);
            ++port;
        }
        for (i = 0; i < serverConfigs.size(); ++i) {
            this.addExposedPort(port);
            serverConfigs.get(i).setProxyListenPort(port);
            this.addExposedPort(++port);
            serverConfigs.get(i).setProxyHttpListenPort(port);
            ++port;
        }
    }

    public void configure() {
        this.withCommand(new String[]{"-c", "while [ ! -f /gemfire_proxy_start.sh ]; do sleep 0.1; done; /gemfire_proxy_start.sh"});
    }

    protected void containerIsStarting(InspectContainerResponse containerInfo) {
        String socatHttpCommand;
        String socatCommand;
        ArrayList<String> socats = new ArrayList<String>();
        for (MemberConfig config : this.locatorConfigs) {
            socatCommand = this.generateSocatCommand(config);
            socats.add(socatCommand);
            this.logger().info("  " + socatCommand);
            socatHttpCommand = this.generateHttpSocatCommand(config);
            socats.add(socatHttpCommand);
            this.logger().info("  " + socatHttpCommand);
        }
        for (MemberConfig config : this.serverConfigs) {
            socatCommand = this.generateSocatCommand(config);
            socats.add(socatCommand);
            this.logger().info("  " + socatCommand);
            socatHttpCommand = this.generateHttpSocatCommand(config);
            socats.add(socatHttpCommand);
            this.logger().info("  " + socatHttpCommand);
        }
        String command = "#!/bin/sh\n";
        command = command + String.join((CharSequence)" & ", socats);
        this.copyFileToContainer(Transferable.of((String)command, (int)511), STARTER_SCRIPT);
    }

    private String generateSocatCommand(MemberConfig memberConfig) {
        int internalPort = memberConfig.getProxyListenPort();
        int mappedPort = this.getMappedPort(internalPort);
        memberConfig.setProxyPublicPort(mappedPort);
        return String.format("socat TCP-LISTEN:%d,fork,reuseaddr TCP:%s:%d", internalPort, memberConfig.getHostname(), mappedPort);
    }

    private String generateHttpSocatCommand(MemberConfig memberConfig) {
        int internalPort = memberConfig.getProxyHttpListenPort();
        int mappedPort = this.getMappedPort(internalPort);
        memberConfig.setProxyHttpPublicPort(mappedPort);
        return String.format("socat TCP-LISTEN:%d,fork,reuseaddr TCP:%s:%d", internalPort, memberConfig.getHostname(), 7070);
    }
}

