/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.ollama;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import dev.langchain4j.model.ollama.Message;
import dev.langchain4j.model.ollama.Options;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
class ChatRequest {
    private String model;
    private List<Message> messages;
    private Options options;
    private String format;
    private Boolean stream;

    public static ChatRequestBuilder builder() {
        return new ChatRequestBuilder();
    }

    public String getModel() {
        return this.model;
    }

    public List<Message> getMessages() {
        return this.messages;
    }

    public Options getOptions() {
        return this.options;
    }

    public String getFormat() {
        return this.format;
    }

    public Boolean getStream() {
        return this.stream;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public void setMessages(List<Message> messages) {
        this.messages = messages;
    }

    public void setOptions(Options options) {
        this.options = options;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public void setStream(Boolean stream) {
        this.stream = stream;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChatRequest)) {
            return false;
        }
        ChatRequest other = (ChatRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$stream = this.getStream();
        Boolean other$stream = other.getStream();
        if (this$stream == null ? other$stream != null : !((Object)this$stream).equals(other$stream)) {
            return false;
        }
        String this$model = this.getModel();
        String other$model = other.getModel();
        if (this$model == null ? other$model != null : !this$model.equals(other$model)) {
            return false;
        }
        List<Message> this$messages = this.getMessages();
        List<Message> other$messages = other.getMessages();
        if (this$messages == null ? other$messages != null : !((Object)this$messages).equals(other$messages)) {
            return false;
        }
        Options this$options = this.getOptions();
        Options other$options = other.getOptions();
        if (this$options == null ? other$options != null : !((Object)this$options).equals(other$options)) {
            return false;
        }
        String this$format = this.getFormat();
        String other$format = other.getFormat();
        return !(this$format == null ? other$format != null : !this$format.equals(other$format));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ChatRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $stream = this.getStream();
        result = result * 59 + ($stream == null ? 43 : ((Object)$stream).hashCode());
        String $model = this.getModel();
        result = result * 59 + ($model == null ? 43 : $model.hashCode());
        List<Message> $messages = this.getMessages();
        result = result * 59 + ($messages == null ? 43 : ((Object)$messages).hashCode());
        Options $options = this.getOptions();
        result = result * 59 + ($options == null ? 43 : ((Object)$options).hashCode());
        String $format = this.getFormat();
        result = result * 59 + ($format == null ? 43 : $format.hashCode());
        return result;
    }

    public String toString() {
        return "ChatRequest(model=" + this.getModel() + ", messages=" + this.getMessages() + ", options=" + this.getOptions() + ", format=" + this.getFormat() + ", stream=" + this.getStream() + ")";
    }

    public ChatRequest() {
    }

    public ChatRequest(String model, List<Message> messages, Options options, String format, Boolean stream) {
        this.model = model;
        this.messages = messages;
        this.options = options;
        this.format = format;
        this.stream = stream;
    }

    public static class ChatRequestBuilder {
        private String model;
        private List<Message> messages;
        private Options options;
        private String format;
        private Boolean stream;

        ChatRequestBuilder() {
        }

        public ChatRequestBuilder model(String model) {
            this.model = model;
            return this;
        }

        public ChatRequestBuilder messages(List<Message> messages) {
            this.messages = messages;
            return this;
        }

        public ChatRequestBuilder options(Options options) {
            this.options = options;
            return this;
        }

        public ChatRequestBuilder format(String format) {
            this.format = format;
            return this;
        }

        public ChatRequestBuilder stream(Boolean stream) {
            this.stream = stream;
            return this;
        }

        public ChatRequest build() {
            return new ChatRequest(this.model, this.messages, this.options, this.format, this.stream);
        }

        public String toString() {
            return "ChatRequest.ChatRequestBuilder(model=" + this.model + ", messages=" + this.messages + ", options=" + this.options + ", format=" + this.format + ", stream=" + this.stream + ")";
        }
    }
}

