/*
 * Decompiled with CFR 0.152.
 */
package org.drools.smf;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.drools.smf.ConditionFactory;
import org.drools.smf.ConsequenceFactory;
import org.drools.smf.DurationFactory;
import org.drools.smf.ExtractorFactory;
import org.drools.smf.ObjectTypeFactory;
import org.drools.smf.RuleFactory;
import org.drools.smf.SemanticModule;

public class SimpleSemanticModule
implements SemanticModule {
    private String uri;
    private Map ruleFactories;
    private Map objectTypeFactories;
    private Map conditionFactories;
    private Map extractorFactories;
    private Map consequenceFactories;
    private Map durationFactories;

    public SimpleSemanticModule(String uri) {
        this.uri = uri;
        this.ruleFactories = new HashMap();
        this.objectTypeFactories = new HashMap();
        this.conditionFactories = new HashMap();
        this.extractorFactories = new HashMap();
        this.consequenceFactories = new HashMap();
        this.durationFactories = new HashMap();
    }

    public String getUri() {
        return this.uri;
    }

    public void addRuleFactory(String name, RuleFactory factory) {
        this.ruleFactories.put(name, factory);
    }

    public RuleFactory getRuleFactory(String name) {
        return (RuleFactory)this.ruleFactories.get(name);
    }

    public Set getRuleFactoryNames() {
        return this.ruleFactories.keySet();
    }

    public void addObjectTypeFactory(String name, ObjectTypeFactory factory) {
        this.objectTypeFactories.put(name, factory);
    }

    public ObjectTypeFactory getObjectTypeFactory(String name) {
        return (ObjectTypeFactory)this.objectTypeFactories.get(name);
    }

    public Set getObjectTypeFactoryNames() {
        return this.objectTypeFactories.keySet();
    }

    public void addConditionFactory(String name, ConditionFactory factory) {
        this.conditionFactories.put(name, factory);
    }

    public ConditionFactory getConditionFactory(String name) {
        return (ConditionFactory)this.conditionFactories.get(name);
    }

    public Set getConditionFactoryNames() {
        return this.conditionFactories.keySet();
    }

    public void addExtractorFactory(String name, ExtractorFactory factory) {
        this.extractorFactories.put(name, factory);
    }

    public ExtractorFactory getExtractorFactory(String name) {
        return (ExtractorFactory)this.extractorFactories.get(name);
    }

    public Set getExtractorFactoryNames() {
        return this.extractorFactories.keySet();
    }

    public void addConsequenceFactory(String name, ConsequenceFactory factory) {
        this.consequenceFactories.put(name, factory);
    }

    public ConsequenceFactory getConsequenceFactory(String name) {
        return (ConsequenceFactory)this.consequenceFactories.get(name);
    }

    public Set getConsequenceFactoryNames() {
        return this.consequenceFactories.keySet();
    }

    public void addDurationFactory(String name, DurationFactory factory) {
        this.durationFactories.put(name, factory);
    }

    public DurationFactory getDurationFactory(String name) {
        return (DurationFactory)this.durationFactories.get(name);
    }

    public Set getDurationFactoryNames() {
        return this.durationFactories.keySet();
    }
}

