/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.nio.reactor;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.Socket;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Iterator;
import java.util.Set;
import org.apache.http.impl.nio.reactor.BaseIOReactor;
import org.apache.http.impl.nio.reactor.ChannelEntry;
import org.apache.http.nio.params.NIOReactorParams;
import org.apache.http.nio.reactor.IOEventDispatch;
import org.apache.http.nio.reactor.IOReactor;
import org.apache.http.nio.reactor.IOReactorException;
import org.apache.http.nio.reactor.IOReactorExceptionHandler;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.util.concurrent.ThreadFactory;

public abstract class AbstractMultiworkerIOReactor
implements IOReactor {
    protected volatile int status;
    protected final HttpParams params;
    protected final Selector selector;
    protected final long selectTimeout;
    private final int workerCount;
    private final ThreadFactory threadFactory;
    private final BaseIOReactor[] dispatchers;
    private final Worker[] workers;
    private final Thread[] threads;
    protected IOReactorExceptionHandler exceptionHandler;
    private int currentWorker = 0;

    public AbstractMultiworkerIOReactor(int workerCount, ThreadFactory threadFactory, HttpParams params) throws IOReactorException {
        if (workerCount <= 0) {
            throw new IllegalArgumentException("Worker count may not be negative or zero");
        }
        if (params == null) {
            throw new IllegalArgumentException("HTTP parameters may not be negative or zero");
        }
        try {
            this.selector = Selector.open();
        }
        catch (IOException ex) {
            throw new IOReactorException("Failure opening selector", ex);
        }
        this.params = params;
        this.selectTimeout = NIOReactorParams.getSelectInterval(params);
        this.workerCount = workerCount;
        this.threadFactory = threadFactory != null ? threadFactory : new DefaultThreadFactory();
        this.dispatchers = new BaseIOReactor[workerCount];
        for (int i = 0; i < this.dispatchers.length; ++i) {
            this.dispatchers[i] = new BaseIOReactor(this.selectTimeout);
        }
        this.workers = new Worker[workerCount];
        this.threads = new Thread[workerCount];
        this.status = 0;
    }

    public int getStatus() {
        return this.status;
    }

    public void setExceptionHandler(IOReactorExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
        for (int i = 0; i < this.workerCount; ++i) {
            BaseIOReactor dispatcher = this.dispatchers[i];
            dispatcher.setExceptionHandler(exceptionHandler);
        }
    }

    protected abstract void processEvents(int var1) throws IOReactorException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(IOEventDispatch eventDispatch) throws InterruptedIOException, IOReactorException {
        int i;
        if (eventDispatch == null) {
            throw new IllegalArgumentException("Event dispatcher may not be null");
        }
        this.status = 1;
        for (i = 0; i < this.workerCount; ++i) {
            BaseIOReactor dispatcher = this.dispatchers[i];
            this.workers[i] = new Worker(dispatcher, eventDispatch);
            this.threads[i] = this.threadFactory.newThread((Runnable)this.workers[i]);
        }
        for (i = 0; i < this.workerCount; ++i) {
            if (this.status != 1) {
                return;
            }
            this.threads[i].start();
        }
        try {
            block16: while (true) {
                int readyCount;
                try {
                    readyCount = this.selector.select(this.selectTimeout);
                }
                catch (InterruptedIOException ex) {
                    throw ex;
                }
                catch (IOException ex) {
                    throw new IOReactorException("Unexpected selector failure", ex);
                }
                if (this.status > 1) {
                    break;
                }
                this.processEvents(readyCount);
                int i2 = 0;
                while (true) {
                    if (i2 >= this.workerCount) continue block16;
                    Worker worker = this.workers[i2];
                    Thread thread = this.threads[i2];
                    if (!thread.isAlive()) {
                        Exception ex = worker.getException();
                        if (ex instanceof IOReactorException) {
                            throw (IOReactorException)ex;
                        }
                        if (ex instanceof InterruptedIOException) {
                            throw (InterruptedIOException)ex;
                        }
                        if (ex instanceof RuntimeException) {
                            throw (RuntimeException)ex;
                        }
                        if (ex != null) {
                            throw new IOReactorException(ex.getMessage(), ex);
                        }
                    }
                    ++i2;
                }
                break;
            }
        }
        catch (ClosedSelectorException ex) {
            try {
                this.shutdown(500L);
            }
            catch (IOException ex2) {
                throw new IOReactorException(ex2.getMessage(), ex2);
            }
        }
        finally {
            try {
                this.shutdown(500L);
            }
            catch (IOException ex) {
                throw new IOReactorException(ex.getMessage(), ex);
            }
        }
    }

    public void shutdown(long gracePeriod) throws IOException {
        BaseIOReactor dispatcher;
        int i;
        if (this.status > 1) {
            return;
        }
        this.status = 2;
        this.selector.wakeup();
        Set<SelectionKey> keys = this.selector.keys();
        Iterator<SelectionKey> it = keys.iterator();
        while (it.hasNext()) {
            try {
                SelectionKey key = it.next();
                SelectableChannel channel = key.channel();
                if (channel == null) continue;
                channel.close();
            }
            catch (IOException ignore) {}
        }
        this.selector.close();
        for (i = 0; i < this.workerCount; ++i) {
            dispatcher = this.dispatchers[i];
            dispatcher.gracefulShutdown();
        }
        try {
            for (i = 0; i < this.workerCount; ++i) {
                dispatcher = this.dispatchers[i];
                if (dispatcher.getStatus() != 0) {
                    dispatcher.awaitShutdown(gracePeriod);
                }
                if (dispatcher.getStatus() == 3) continue;
                dispatcher.hardShutdown();
            }
            for (i = 0; i < this.workerCount; ++i) {
                Thread t = this.threads[i];
                if (t == null) continue;
                t.join(gracePeriod);
            }
        }
        catch (InterruptedException ex) {
            throw new InterruptedIOException(ex.getMessage());
        }
        finally {
            this.status = 3;
        }
    }

    public void shutdown() throws IOException {
        this.shutdown(500L);
    }

    protected void addChannel(ChannelEntry entry) {
        this.dispatchers[this.currentWorker++ % this.workerCount].addChannel(entry);
    }

    protected SelectionKey registerChannel(SelectableChannel channel, int ops) throws ClosedChannelException {
        return channel.register(this.selector, ops);
    }

    protected void prepareSocket(Socket socket) throws IOException {
        socket.setTcpNoDelay(HttpConnectionParams.getTcpNoDelay((HttpParams)this.params));
        socket.setSoTimeout(HttpConnectionParams.getSoTimeout((HttpParams)this.params));
        int linger = HttpConnectionParams.getLinger((HttpParams)this.params);
        if (linger >= 0) {
            socket.setSoLinger(linger > 0, linger);
        }
    }

    static class DefaultThreadFactory
    implements ThreadFactory {
        private static int COUNT = 0;

        DefaultThreadFactory() {
        }

        public Thread newThread(Runnable r) {
            return new Thread(r, "I/O dispatcher " + ++COUNT);
        }
    }

    static class Worker
    implements Runnable {
        final BaseIOReactor dispatcher;
        final IOEventDispatch eventDispatch;
        private volatile Exception exception;

        public Worker(BaseIOReactor dispatcher, IOEventDispatch eventDispatch) {
            this.dispatcher = dispatcher;
            this.eventDispatch = eventDispatch;
        }

        public void run() {
            try {
                this.dispatcher.execute(this.eventDispatch);
            }
            catch (InterruptedIOException ex) {
                this.exception = ex;
            }
            catch (IOReactorException ex) {
                this.exception = ex;
            }
            catch (RuntimeException ex) {
                this.exception = ex;
            }
        }

        public Exception getException() {
            return this.exception;
        }
    }
}

