/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.nio.reactor;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.Set;
import org.apache.http.impl.nio.reactor.AbstractMultiworkerIOReactor;
import org.apache.http.impl.nio.reactor.ChannelEntry;
import org.apache.http.nio.reactor.IOReactorException;
import org.apache.http.nio.reactor.ListeningIOReactor;
import org.apache.http.params.HttpParams;
import org.apache.http.util.concurrent.ThreadFactory;

public class DefaultListeningIOReactor
extends AbstractMultiworkerIOReactor
implements ListeningIOReactor {
    public DefaultListeningIOReactor(int workerCount, ThreadFactory threadFactory, HttpParams params) throws IOReactorException {
        super(workerCount, threadFactory, params);
    }

    public DefaultListeningIOReactor(int workerCount, HttpParams params) throws IOReactorException {
        this(workerCount, null, params);
    }

    protected void processEvents(int readyCount) throws IOReactorException {
        if (readyCount > 0) {
            Set<SelectionKey> selectedKeys = this.selector.selectedKeys();
            Iterator<SelectionKey> it = selectedKeys.iterator();
            while (it.hasNext()) {
                SelectionKey key = it.next();
                this.processEvent(key);
            }
            selectedKeys.clear();
        }
    }

    private void processEvent(SelectionKey key) throws IOReactorException {
        block6: {
            try {
                SocketChannel socketChannel;
                block8: {
                    block7: {
                        if (!key.isAcceptable()) break block6;
                        ServerSocketChannel serverChannel = (ServerSocketChannel)key.channel();
                        socketChannel = null;
                        try {
                            socketChannel = serverChannel.accept();
                        }
                        catch (IOException ex) {
                            if (this.exceptionHandler != null && this.exceptionHandler.handle(ex)) break block7;
                            throw new IOReactorException("Failure accepting connection", ex);
                        }
                    }
                    if (socketChannel == null) break block6;
                    try {
                        this.prepareSocket(socketChannel.socket());
                    }
                    catch (IOException ex) {
                        if (this.exceptionHandler != null && this.exceptionHandler.handle(ex)) break block8;
                        throw new IOReactorException("Failure initalizing socket", ex);
                    }
                }
                ChannelEntry entry = new ChannelEntry(socketChannel);
                this.addChannel(entry);
            }
            catch (CancelledKeyException ex) {
                key.attach(null);
            }
        }
    }

    public SocketAddress listen(SocketAddress address) throws IOException {
        if (this.status > 1) {
            throw new IllegalStateException("I/O reactor has been shut down");
        }
        ServerSocketChannel serverChannel = ServerSocketChannel.open();
        serverChannel.configureBlocking(false);
        serverChannel.socket().bind(address);
        SelectionKey key = serverChannel.register(this.selector, 16);
        key.attach(null);
        return serverChannel.socket().getLocalSocketAddress();
    }
}

