/*
 * Decompiled with CFR 0.152.
 */
package org.cqframework.cql.cql2elm.model;

import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.runtime.misc.Interval;
import org.hl7.elm.r1.Element;

public class Chunk {
    private Interval interval;
    private Element element;
    private List<Chunk> chunks;

    public Interval getInterval() {
        return this.interval;
    }

    public void setInterval(Interval interval) {
        this.interval = interval;
    }

    public Chunk withInterval(Interval interval) {
        this.setInterval(interval);
        return this;
    }

    public Element getElement() {
        return this.element;
    }

    public void setElement(Element element) {
        this.element = element;
    }

    public Chunk withElement(Element element) {
        this.setElement(element);
        return this;
    }

    private void ensureChunks() {
        if (this.chunks == null) {
            this.chunks = new ArrayList<Chunk>();
            this.chunks.add(new Chunk().withInterval(this.interval));
        }
    }

    public Iterable<Chunk> getChunks() {
        this.ensureChunks();
        return this.chunks;
    }

    public boolean hasChunks() {
        return this.chunks != null;
    }

    public void addChunk(Chunk chunk) {
        if (chunk.getInterval().a < this.interval.a || chunk.getInterval().b > this.interval.b) {
            throw new IllegalArgumentException("Child chunk cannot be added because it is not contained within the parent chunk.");
        }
        this.ensureChunks();
        int chunkIndex = -1;
        Chunk targetChunk = null;
        for (int i = 0; i < this.chunks.size(); ++i) {
            if (chunk.getInterval().a < this.chunks.get((int)i).getInterval().a || chunk.getInterval().a > this.chunks.get((int)i).getInterval().b) continue;
            chunkIndex = i;
            targetChunk = this.chunks.get(chunkIndex);
            break;
        }
        if (chunk.getInterval().a == targetChunk.getInterval().a) {
            this.chunks.add(chunkIndex, chunk);
            ++chunkIndex;
            int newA = chunk.getInterval().b + 1;
            while (newA > this.chunks.get((int)chunkIndex).getInterval().b) {
                this.chunks.remove(chunkIndex);
                if (chunkIndex < this.chunks.size()) continue;
            }
            if (chunkIndex < this.chunks.size()) {
                this.chunks.get(chunkIndex).setInterval(new Interval(newA, this.chunks.get((int)chunkIndex).getInterval().b));
            }
        } else {
            int newB = chunk.getInterval().a - 1;
            int newA = chunk.getInterval().b + 1;
            int oldA = this.chunks.get((int)chunkIndex).getInterval().a;
            int oldB = this.chunks.get((int)chunkIndex).getInterval().b;
            this.chunks.get(chunkIndex).setInterval(new Interval(oldA, newB));
            this.chunks.add(++chunkIndex, chunk);
            ++chunkIndex;
            if (newA <= oldB) {
                this.chunks.add(chunkIndex, new Chunk().withInterval(new Interval(newA, oldB)));
            }
        }
    }
}

