/*
 * Decompiled with CFR 0.152.
 */
package org.cqframework.cql.cql2elm.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cqframework.cql.cql2elm.model.Conversion;
import org.cqframework.cql.cql2elm.model.GenericOperator;
import org.cqframework.cql.cql2elm.model.InstantiationResult;
import org.cqframework.cql.cql2elm.model.Operator;
import org.cqframework.cql.cql2elm.model.OperatorMap;
import org.cqframework.cql.cql2elm.model.Signature;
import org.hl7.cql.model.ChoiceType;
import org.hl7.cql.model.DataType;
import org.hl7.cql.model.IntervalType;
import org.hl7.cql.model.ListType;

public class ConversionMap {
    private Map<DataType, List<Conversion>> map = new HashMap<DataType, List<Conversion>>();
    private List<Conversion> genericConversions = new ArrayList<Conversion>();
    private boolean demotion = true;
    private boolean promotion = true;

    public void enableDemotion() {
        this.demotion = true;
    }

    public void disableDemotion() {
        this.demotion = false;
    }

    public void enablePromotion() {
        this.promotion = true;
    }

    public void disablePromotion() {
        this.promotion = false;
    }

    public void add(Conversion conversion) {
        if (conversion == null) {
            throw new IllegalArgumentException("conversion is null.");
        }
        if (conversion.isGeneric()) {
            List<Conversion> conversions = this.getGenericConversions();
            if (conversions.contains(conversion)) {
                throw new IllegalArgumentException(String.format("Conversion from %s to %s is already defined.", conversion.getFromType().toString(), conversion.getToType().toString()));
            }
            conversions.add(conversion);
        } else {
            List<Conversion> conversions = this.getConversions(conversion.getFromType());
            if (conversions.contains(conversion)) {
                throw new IllegalArgumentException(String.format("Conversion from %s to %s is already defined.", conversion.getFromType().toString(), conversion.getToType().toString()));
            }
            conversions.add(conversion);
        }
    }

    public List<Conversion> getGenericConversions() {
        return this.genericConversions;
    }

    public List<Conversion> getConversions(DataType fromType) {
        List<Conversion> conversions = this.map.get(fromType);
        if (conversions == null) {
            conversions = new ArrayList<Conversion>();
            this.map.put(fromType, conversions);
        }
        return conversions;
    }

    public Conversion findCompatibleConversion(DataType fromType, DataType toType) {
        if (fromType.isCompatibleWith(toType)) {
            return new Conversion(fromType, toType);
        }
        return null;
    }

    public Conversion findChoiceConversion(ChoiceType fromType, DataType toType, OperatorMap operatorMap) {
        Conversion result = null;
        for (DataType choice : fromType.getTypes()) {
            Conversion choiceConversion = this.findConversion(choice, toType, true, operatorMap);
            if (choiceConversion == null) continue;
            if (result == null) {
                result = new Conversion(fromType, toType, choiceConversion);
                continue;
            }
            result.addAlternativeConversion(choiceConversion);
        }
        return result;
    }

    public Conversion findListConversion(ListType fromType, ListType toType, OperatorMap operatorMap) {
        Conversion elementConversion = this.findConversion(fromType.getElementType(), toType.getElementType(), true, operatorMap);
        if (elementConversion != null) {
            return new Conversion(fromType, toType, elementConversion);
        }
        return null;
    }

    public Conversion findIntervalConversion(IntervalType fromType, IntervalType toType, OperatorMap operatorMap) {
        Conversion pointConversion = this.findConversion(fromType.getPointType(), toType.getPointType(), true, operatorMap);
        if (pointConversion != null) {
            return new Conversion(fromType, toType, pointConversion);
        }
        return null;
    }

    public Conversion findListDemotion(ListType fromType, DataType toType, OperatorMap operatorMap) {
        DataType elementType = fromType.getElementType();
        if (elementType.isSubTypeOf(toType)) {
            return new Conversion(fromType, toType, null);
        }
        Conversion elementConversion = this.findConversion(elementType, toType, true, operatorMap);
        if (elementConversion != null) {
            return new Conversion(fromType, toType, elementConversion);
        }
        return null;
    }

    public Conversion findListPromotion(DataType fromType, ListType toType, OperatorMap operatorMap) {
        if (fromType.isSubTypeOf(toType.getElementType())) {
            return new Conversion(fromType, toType, null);
        }
        Conversion elementConversion = this.findConversion(fromType, toType.getElementType(), true, operatorMap);
        if (elementConversion != null) {
            return new Conversion(fromType, toType, elementConversion);
        }
        return null;
    }

    public void ensureGenericConversionInstantiated(DataType fromType, DataType toType, boolean isImplicit, OperatorMap operatorMap) {
        for (Conversion c : this.getGenericConversions()) {
            InstantiationResult instantiationResult;
            Operator operator;
            if (c.getOperator() == null || (operator = (instantiationResult = ((GenericOperator)c.getOperator()).instantiate(new Signature(fromType), operatorMap, this)).getOperator()) == null || operatorMap.containsOperator(operator)) continue;
            operatorMap.addOperator(operator);
            Conversion conversion = new Conversion(operator, true);
            this.add(conversion);
        }
    }

    private Conversion internalFindConversion(DataType fromType, DataType toType, boolean isImplicit) {
        Conversion result = null;
        int score = Integer.MAX_VALUE;
        for (Conversion conversion : this.getConversions(fromType)) {
            int newScore;
            if (isImplicit && !conversion.isImplicit() || !conversion.getToType().isSuperTypeOf(toType) && !conversion.getToType().isGeneric()) continue;
            int n = conversion.getToType().equals(toType) ? 0 : (newScore = conversion.getToType().isGeneric() ? 1 : 2);
            if (newScore < score) {
                result = conversion;
                score = newScore;
                continue;
            }
            if (newScore != score) continue;
            throw new IllegalArgumentException(String.format("Ambiguous implicit conversion from %s to %s or %s.", fromType.toString(), result.getToType().toString(), conversion.getToType().toString()));
        }
        return result;
    }

    public Conversion findConversion(DataType fromType, DataType toType, boolean isImplicit, OperatorMap operatorMap) {
        Conversion result = this.findCompatibleConversion(fromType, toType);
        if (result == null) {
            result = this.internalFindConversion(fromType, toType, isImplicit);
        }
        if (result == null) {
            this.ensureGenericConversionInstantiated(fromType, toType, isImplicit, operatorMap);
            result = this.internalFindConversion(fromType, toType, isImplicit);
        }
        if (result == null) {
            if (fromType instanceof ListType && !(toType instanceof ListType) && this.demotion) {
                result = this.findListDemotion((ListType)fromType, toType, operatorMap);
            }
            if (!(fromType instanceof ListType) && toType instanceof ListType && this.promotion) {
                result = this.findListPromotion(fromType, (ListType)toType, operatorMap);
            }
            if (fromType instanceof ChoiceType) {
                result = this.findChoiceConversion((ChoiceType)fromType, toType, operatorMap);
            }
            if (fromType instanceof ListType && toType instanceof ListType) {
                result = this.findListConversion((ListType)fromType, (ListType)toType, operatorMap);
            }
            if (fromType instanceof IntervalType && toType instanceof IntervalType) {
                result = this.findIntervalConversion((IntervalType)fromType, (IntervalType)toType, operatorMap);
            }
        }
        return result;
    }
}

