/*
 * Decompiled with CFR 0.152.
 */
package org.cqframework.cql.cql2elm.model;

import java.util.ArrayList;
import java.util.List;
import org.cqframework.cql.cql2elm.model.Conversion;
import org.cqframework.cql.cql2elm.model.ConversionMap;
import org.cqframework.cql.cql2elm.model.OperatorMap;
import org.hl7.cql.model.DataType;
import org.hl7.cql.model.InstantiationContext;

public class Signature {
    private List<DataType> operandTypes = new ArrayList<DataType>();

    public Signature(DataType ... operandTypes) {
        if (operandTypes == null) {
            throw new IllegalArgumentException("operandTypes is null");
        }
        for (DataType operandType : operandTypes) {
            if (operandType == null) {
                throw new IllegalArgumentException("operandTypes in signatures cannot be null");
            }
            this.operandTypes.add(operandType);
        }
    }

    public Iterable<DataType> getOperandTypes() {
        return this.operandTypes;
    }

    public int getSize() {
        return this.operandTypes.size();
    }

    public boolean isSuperTypeOf(Signature other) {
        if (this.operandTypes.size() == other.operandTypes.size()) {
            for (int i = 0; i < this.operandTypes.size(); ++i) {
                if (this.operandTypes.get(i).isSuperTypeOf(other.operandTypes.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean isSubTypeOf(Signature other) {
        if (this.operandTypes.size() == other.operandTypes.size()) {
            for (int i = 0; i < this.operandTypes.size(); ++i) {
                if (this.operandTypes.get(i).isSubTypeOf(other.operandTypes.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean isInstantiable(Signature callSignature, InstantiationContext context) {
        if (this.operandTypes.size() == callSignature.operandTypes.size()) {
            for (int i = 0; i < this.operandTypes.size(); ++i) {
                if (this.operandTypes.get(i).isInstantiable(callSignature.operandTypes.get(i), context)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public Signature instantiate(InstantiationContext context) {
        DataType[] result = new DataType[this.operandTypes.size()];
        for (int i = 0; i < this.operandTypes.size(); ++i) {
            result[i] = this.operandTypes.get(i).instantiate(context);
        }
        return new Signature(result);
    }

    public boolean isConvertibleTo(Signature other, ConversionMap conversionMap, OperatorMap operatorMap, Conversion[] conversions) {
        if (this.operandTypes.size() == other.operandTypes.size()) {
            for (int i = 0; i < this.operandTypes.size(); ++i) {
                if (this.operandTypes.get(i).isSubTypeOf(other.operandTypes.get(i))) continue;
                Conversion conversion = conversionMap.findConversion(this.operandTypes.get(i), other.operandTypes.get(i), true, operatorMap);
                if (conversion != null) {
                    conversions[i] = conversion;
                    continue;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int result = 53;
        for (DataType operandType : this.operandTypes) {
            result += 39 * operandType.hashCode();
        }
        return result;
    }

    public boolean equals(Object o) {
        if (o instanceof Signature) {
            Signature that = (Signature)o;
            if (this.operandTypes.size() == that.operandTypes.size()) {
                for (int i = 0; i < this.operandTypes.size(); ++i) {
                    if (this.operandTypes.get(i).equals(that.operandTypes.get(i))) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("(");
        for (int i = 0; i < this.operandTypes.size(); ++i) {
            if (i > 0) {
                builder.append(",");
            }
            builder.append(this.operandTypes.get(i).toString());
        }
        builder.append(")");
        return builder.toString();
    }
}

