/*
 * Decompiled with CFR 0.152.
 */
package io.aeron;

import io.aeron.logbuffer.LogBufferDescriptor;
import java.util.Map;
import org.agrona.AsciiEncoding;
import org.agrona.collections.ArrayUtil;
import org.agrona.collections.Object2ObjectHashMap;

public class ChannelUri {
    public static final String AERON_SCHEME = "aeron";
    public static final String SPY_QUALIFIER = "aeron-spy";
    public static final long INVALID_TAG = -1L;
    private static final int CHANNEL_TAG_INDEX = 0;
    private static final int ENTITY_TAG_INDEX = 1;
    private static final String AERON_PREFIX = "aeron:";
    private String prefix;
    private String media;
    private final Map<String, String> params;
    private String[] tags;

    public ChannelUri(String prefix, String media, Map<String, String> params) {
        this.prefix = prefix;
        this.media = media;
        this.params = params;
        this.tags = ChannelUri.splitTags(params.get("tags"));
    }

    public ChannelUri(String media, Map<String, String> params) {
        this("", media, params);
    }

    public String prefix() {
        return this.prefix;
    }

    public ChannelUri prefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public String media() {
        return this.media;
    }

    public ChannelUri media(String media) {
        this.media = media;
        return this;
    }

    public String scheme() {
        return AERON_SCHEME;
    }

    public String get(String key) {
        return this.params.get(key);
    }

    public String get(String key, String defaultValue) {
        String value = this.params.get(key);
        if (null != value) {
            return value;
        }
        return defaultValue;
    }

    public String put(String key, String value) {
        return this.params.put(key, value);
    }

    public String remove(String key) {
        return this.params.remove(key);
    }

    public boolean containsKey(String key) {
        return this.params.containsKey(key);
    }

    public String channelTag() {
        return this.tags.length > 0 ? this.tags[0] : null;
    }

    public String entityTag() {
        return this.tags.length > 1 ? this.tags[1] : null;
    }

    public String toString() {
        StringBuilder sb;
        if (this.prefix == null || "".equals(this.prefix)) {
            sb = new StringBuilder(this.params.size() * 20 + 10);
        } else {
            sb = new StringBuilder(this.params.size() * 20 + 20);
            sb.append(this.prefix);
            if (!this.prefix.endsWith(":")) {
                sb.append(':');
            }
        }
        sb.append(AERON_PREFIX).append(this.media);
        if (this.params.size() > 0) {
            sb.append('?');
            for (Map.Entry<String, String> entry : this.params.entrySet()) {
                sb.append(entry.getKey()).append('=').append(entry.getValue()).append('|');
            }
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    public void initialPosition(long position, int initialTermId, int termLength) {
        int bitsToShift = LogBufferDescriptor.positionBitsToShift(termLength);
        int termId = LogBufferDescriptor.computeTermIdFromPosition(position, bitsToShift, initialTermId);
        int termOffset = (int)(position & (long)(termLength - 1));
        this.put("init-term-id", Integer.toString(initialTermId));
        this.put("term-id", Integer.toString(termId));
        this.put("term-offset", Integer.toString(termOffset));
        this.put("term-length", Integer.toString(termLength));
    }

    public static ChannelUri parse(CharSequence cs) {
        String prefix;
        int position = 0;
        if (ChannelUri.startsWith(cs, "aeron-spy:")) {
            prefix = SPY_QUALIFIER;
            position = "aeron-spy:".length();
        } else {
            prefix = "";
        }
        if (!ChannelUri.startsWith(cs, position, AERON_PREFIX)) {
            throw new IllegalArgumentException("Aeron URIs must start with 'aeron:', found: '" + cs + "'");
        }
        position += AERON_PREFIX.length();
        StringBuilder builder = new StringBuilder();
        Object2ObjectHashMap params = new Object2ObjectHashMap();
        String media = null;
        String key = null;
        State state = State.MEDIA;
        block19: for (int i = position; i < cs.length(); ++i) {
            char c = cs.charAt(i);
            switch (state) {
                case MEDIA: {
                    switch (c) {
                        case '?': {
                            media = builder.toString();
                            builder.setLength(0);
                            state = State.PARAMS_KEY;
                            continue block19;
                        }
                        case ':': {
                            throw new IllegalArgumentException("encountered ':' within media definition");
                        }
                    }
                    builder.append(c);
                    continue block19;
                }
                case PARAMS_KEY: {
                    switch (c) {
                        case '=': {
                            key = builder.toString();
                            builder.setLength(0);
                            state = State.PARAMS_VALUE;
                            continue block19;
                        }
                    }
                    builder.append(c);
                    continue block19;
                }
                case PARAMS_VALUE: {
                    switch (c) {
                        case '|': {
                            params.put(key, builder.toString());
                            builder.setLength(0);
                            state = State.PARAMS_KEY;
                            continue block19;
                        }
                    }
                    builder.append(c);
                    continue block19;
                }
                default: {
                    throw new IllegalStateException("unexpected state=" + (Object)((Object)state));
                }
            }
        }
        switch (state) {
            case MEDIA: {
                media = builder.toString();
                break;
            }
            case PARAMS_VALUE: {
                params.put(key, builder.toString());
                break;
            }
            default: {
                throw new IllegalArgumentException("no more input found, state=" + (Object)((Object)state));
            }
        }
        return new ChannelUri(prefix, media, (Map<String, String>)params);
    }

    public static String addSessionId(String channel, int sessionId) {
        ChannelUri channelUri = ChannelUri.parse(channel);
        channelUri.put("session-id", Integer.toString(sessionId));
        return channelUri.toString();
    }

    public static boolean isTagged(String paramValue) {
        return ChannelUri.startsWith(paramValue, "tag:");
    }

    public static long getTag(String paramValue) {
        return ChannelUri.isTagged(paramValue) ? AsciiEncoding.parseLongAscii((CharSequence)paramValue, (int)4, (int)(paramValue.length() - 4)) : -1L;
    }

    private static boolean startsWith(CharSequence input, int position, CharSequence prefix) {
        if (input.length() - position < prefix.length()) {
            return false;
        }
        for (int i = 0; i < prefix.length(); ++i) {
            if (input.charAt(position + i) == prefix.charAt(i)) continue;
            return false;
        }
        return true;
    }

    private static boolean startsWith(CharSequence input, CharSequence prefix) {
        return ChannelUri.startsWith(input, 0, prefix);
    }

    private static String[] splitTags(CharSequence tags) {
        Object[] stringArray = ArrayUtil.EMPTY_STRING_ARRAY;
        if (null != tags) {
            int currentStartIndex = 0;
            int tagIndex = 0;
            stringArray = new String[2];
            int length = tags.length();
            for (int i = 0; i < length; ++i) {
                if (tags.charAt(i) != ',') continue;
                String tag = null;
                if (i - currentStartIndex > 0) {
                    tag = tags.subSequence(currentStartIndex, i).toString();
                    currentStartIndex = i + 1;
                }
                stringArray = (String[])ArrayUtil.ensureCapacity((Object[])stringArray, (int)(tagIndex + 1));
                stringArray[tagIndex] = tag;
                ++tagIndex;
            }
            if (length - currentStartIndex > 0) {
                stringArray = (String[])ArrayUtil.ensureCapacity((Object[])stringArray, (int)(tagIndex + 1));
                stringArray[tagIndex] = tags.subSequence(currentStartIndex, length).toString();
            }
        }
        return stringArray;
    }

    private static enum State {
        MEDIA,
        PARAMS_KEY,
        PARAMS_VALUE;

    }
}

