/*
 * Decompiled with CFR 0.152.
 */
package io.aeron;

import io.aeron.Aeron;
import io.aeron.CncFileDescriptor;
import io.aeron.exceptions.AeronException;
import io.aeron.exceptions.DriverTimeoutException;
import java.io.File;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.UUID;
import java.util.function.Consumer;
import org.agrona.DirectBuffer;
import org.agrona.IoUtil;
import org.agrona.SystemUtil;
import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.errors.ErrorConsumer;
import org.agrona.concurrent.errors.ErrorLogReader;
import org.agrona.concurrent.ringbuffer.ManyToOneRingBuffer;

public class CommonContext
implements AutoCloseable,
Cloneable {
    public static final String DRIVER_TIMEOUT_PROP_NAME = "aeron.driver.timeout";
    public static final long DEFAULT_DRIVER_TIMEOUT_MS = 10000L;
    public static final long DRIVER_TIMEOUT_MS;
    public static final int NULL_SESSION_ID = -1;
    public static final String AERON_DIR_PROP_NAME = "aeron.dir";
    public static final String AERON_DIR_PROP_DEFAULT;
    public static final String IPC_MEDIA = "ipc";
    public static final String UDP_MEDIA = "udp";
    public static final String IPC_CHANNEL = "aeron:ipc";
    public static final String SPY_PREFIX = "aeron-spy:";
    public static final String ENDPOINT_PARAM_NAME = "endpoint";
    public static final String INTERFACE_PARAM_NAME = "interface";
    public static final String INITIAL_TERM_ID_PARAM_NAME = "init-term-id";
    public static final String TERM_ID_PARAM_NAME = "term-id";
    public static final String TERM_OFFSET_PARAM_NAME = "term-offset";
    public static final String TERM_LENGTH_PARAM_NAME = "term-length";
    public static final String MTU_LENGTH_PARAM_NAME = "mtu";
    public static final String TTL_PARAM_NAME = "ttl";
    public static final String MDC_CONTROL_PARAM_NAME = "control";
    public static final String MDC_CONTROL_MODE_PARAM_NAME = "control-mode";
    public static final String SESSION_ID_PARAM_NAME = "session-id";
    public static final String LINGER_PARAM_NAME = "linger";
    public static final String MDC_CONTROL_MODE_MANUAL = "manual";
    public static final String MDC_CONTROL_MODE_DYNAMIC = "dynamic";
    public static final String RELIABLE_STREAM_PARAM_NAME = "reliable";
    public static final String TAGS_PARAM_NAME = "tags";
    public static final String SPARSE_PARAM_NAME = "sparse";
    private long driverTimeoutMs = DRIVER_TIMEOUT_MS;
    private String aeronDirectoryName = CommonContext.getAeronDirectoryName();
    private File aeronDirectory;
    private File cncFile;
    private UnsafeBuffer countersMetaDataBuffer;
    private UnsafeBuffer countersValuesBuffer;

    public CommonContext clone() {
        try {
            return (CommonContext)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static String getAeronDirectoryName() {
        return System.getProperty(AERON_DIR_PROP_NAME, AERON_DIR_PROP_DEFAULT);
    }

    public static String generateRandomDirName() {
        return AERON_DIR_PROP_DEFAULT + '-' + UUID.randomUUID().toString();
    }

    public CommonContext conclude() {
        this.concludeAeronDirectory();
        this.cncFile = new File(this.aeronDirectory, "cnc.dat");
        return this;
    }

    public CommonContext concludeAeronDirectory() {
        if (null == this.aeronDirectory) {
            this.aeronDirectory = new File(this.aeronDirectoryName);
        }
        return this;
    }

    public String aeronDirectoryName() {
        return this.aeronDirectoryName;
    }

    public File aeronDirectory() {
        return this.aeronDirectory;
    }

    public CommonContext aeronDirectoryName(String dirName) {
        this.aeronDirectoryName = dirName;
        return this;
    }

    public static File newDefaultCncFile() {
        return new File(System.getProperty(AERON_DIR_PROP_NAME, AERON_DIR_PROP_DEFAULT), "cnc.dat");
    }

    public UnsafeBuffer countersMetaDataBuffer() {
        return this.countersMetaDataBuffer;
    }

    public CommonContext countersMetaDataBuffer(UnsafeBuffer countersMetaDataBuffer) {
        this.countersMetaDataBuffer = countersMetaDataBuffer;
        return this;
    }

    public UnsafeBuffer countersValuesBuffer() {
        return this.countersValuesBuffer;
    }

    public CommonContext countersValuesBuffer(UnsafeBuffer countersValuesBuffer) {
        this.countersValuesBuffer = countersValuesBuffer;
        return this;
    }

    public File cncFile() {
        return this.cncFile;
    }

    public CommonContext driverTimeoutMs(long driverTimeoutMs) {
        this.driverTimeoutMs = driverTimeoutMs;
        return this;
    }

    public long driverTimeoutMs() {
        return this.driverTimeoutMs;
    }

    public void deleteAeronDirectory() {
        IoUtil.delete((File)this.aeronDirectory, (boolean)false);
    }

    public MappedByteBuffer mapExistingCncFile(Consumer<String> logger) {
        File cncFile = new File(this.aeronDirectory, "cnc.dat");
        if (cncFile.exists() && cncFile.length() > 0L) {
            if (null != logger) {
                logger.accept("INFO: Aeron CnC file exists: " + cncFile);
            }
            return IoUtil.mapExistingFile((File)cncFile, (String)"cnc.dat");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isDriverActive(File directory, long driverTimeoutMs, Consumer<String> logger) {
        File cncFile = new File(directory, "cnc.dat");
        if (cncFile.exists() && cncFile.length() > 0L) {
            logger.accept("INFO: Aeron CnC file exists: " + cncFile);
            MappedByteBuffer cncByteBuffer = IoUtil.mapExistingFile((File)cncFile, (String)"CnC file");
            try {
                boolean bl = CommonContext.isDriverActive(driverTimeoutMs, logger, cncByteBuffer);
                return bl;
            }
            finally {
                IoUtil.unmap((MappedByteBuffer)cncByteBuffer);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDriverActive(long driverTimeoutMs, Consumer<String> logger) {
        MappedByteBuffer cncByteBuffer = this.mapExistingCncFile(logger);
        try {
            boolean bl = CommonContext.isDriverActive(driverTimeoutMs, logger, cncByteBuffer);
            return bl;
        }
        finally {
            IoUtil.unmap((MappedByteBuffer)cncByteBuffer);
        }
    }

    public static boolean isDriverActive(long driverTimeoutMs, Consumer<String> logger, ByteBuffer cncByteBuffer) {
        int cncVersion;
        if (null == cncByteBuffer) {
            return false;
        }
        UnsafeBuffer cncMetaDataBuffer = CncFileDescriptor.createMetaDataBuffer(cncByteBuffer);
        long startTimeMs = System.currentTimeMillis();
        while (0 == (cncVersion = cncMetaDataBuffer.getIntVolatile(CncFileDescriptor.cncVersionOffset(0)))) {
            if (System.currentTimeMillis() > startTimeMs + driverTimeoutMs) {
                throw new DriverTimeoutException("CnC file is created but not initialised.");
            }
            Aeron.sleep(1L);
        }
        if (14 != cncVersion) {
            throw new AeronException("Aeron CnC version does not match: required=14 version=" + cncVersion);
        }
        ManyToOneRingBuffer toDriverBuffer = new ManyToOneRingBuffer((AtomicBuffer)CncFileDescriptor.createToDriverBuffer(cncByteBuffer, (DirectBuffer)cncMetaDataBuffer));
        long timestamp = toDriverBuffer.consumerHeartbeatTime();
        long now = System.currentTimeMillis();
        long timestampAge = now - timestamp;
        logger.accept("INFO: Aeron toDriver consumer heartbeat is (ms): " + timestampAge);
        return timestampAge <= driverTimeoutMs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int saveErrorLog(PrintStream out) {
        MappedByteBuffer cncByteBuffer = this.mapExistingCncFile(null);
        try {
            int n = this.saveErrorLog(out, cncByteBuffer);
            return n;
        }
        finally {
            IoUtil.unmap((MappedByteBuffer)cncByteBuffer);
        }
    }

    public int saveErrorLog(PrintStream out, ByteBuffer cncByteBuffer) {
        if (null == cncByteBuffer) {
            return 0;
        }
        UnsafeBuffer cncMetaDataBuffer = CncFileDescriptor.createMetaDataBuffer(cncByteBuffer);
        int cncVersion = cncMetaDataBuffer.getInt(CncFileDescriptor.cncVersionOffset(0));
        if (14 != cncVersion) {
            throw new AeronException("Aeron CnC version does not match: required=14 version=" + cncVersion);
        }
        int distinctErrorCount = 0;
        UnsafeBuffer buffer = CncFileDescriptor.createErrorLogBuffer(cncByteBuffer, (DirectBuffer)cncMetaDataBuffer);
        if (ErrorLogReader.hasErrors((AtomicBuffer)buffer)) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSZ");
            ErrorConsumer errorConsumer = (count, firstTimestamp, lastTimestamp, ex) -> CommonContext.formatError(out, dateFormat, count, firstTimestamp, lastTimestamp, ex);
            distinctErrorCount = ErrorLogReader.read((AtomicBuffer)buffer, (ErrorConsumer)errorConsumer);
        }
        out.println();
        out.println(distinctErrorCount + " distinct errors observed.");
        return distinctErrorCount;
    }

    @Override
    public void close() {
    }

    public static void formatError(PrintStream out, SimpleDateFormat dateFormat, int observationCount, long firstObservationTimestamp, long lastObservationTimestamp, String encodedException) {
        out.format("***%n%d observations from %s to %s for:%n %s%n", observationCount, dateFormat.format(new Date(firstObservationTimestamp)), dateFormat.format(new Date(lastObservationTimestamp)), encodedException);
    }

    static {
        File devShmDir;
        DRIVER_TIMEOUT_MS = Long.getLong(DRIVER_TIMEOUT_PROP_NAME, 10000L);
        String baseDirName = null;
        if (SystemUtil.osName().contains("linux") && (devShmDir = new File("/dev/shm")).exists()) {
            baseDirName = "/dev/shm/aeron";
        }
        if (null == baseDirName) {
            baseDirName = IoUtil.tmpDirName() + "aeron";
        }
        AERON_DIR_PROP_DEFAULT = baseDirName + '-' + System.getProperty("user.name", "default");
    }
}

