/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.security;

import io.aeron.security.Authenticator;
import io.aeron.security.AuthenticatorSupplier;
import io.aeron.security.SessionProxy;
import org.agrona.collections.ArrayUtil;

public class DefaultAuthenticatorSupplier
implements AuthenticatorSupplier {
    public static final byte[] NULL_ENCODED_PRINCIPAL = ArrayUtil.EMPTY_BYTE_ARRAY;
    public static final DefaultAuthenticator DEFAULT_AUTHENTICATOR = new DefaultAuthenticator();

    @Override
    public Authenticator get() {
        return DEFAULT_AUTHENTICATOR;
    }

    private static class DefaultAuthenticator
    implements Authenticator {
        private DefaultAuthenticator() {
        }

        @Override
        public void onConnectRequest(long sessionId, byte[] encodedCredentials, long nowMs) {
        }

        @Override
        public void onChallengeResponse(long sessionId, byte[] encodedCredentials, long nowMs) {
        }

        @Override
        public void onConnectedSession(SessionProxy sessionProxy, long nowMs) {
            sessionProxy.authenticate(NULL_ENCODED_PRINCIPAL);
        }

        @Override
        public void onChallengedSession(SessionProxy sessionProxy, long nowMs) {
            sessionProxy.authenticate(NULL_ENCODED_PRINCIPAL);
        }
    }
}

