/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.maven.sphinx;

import io.airlift.maven.sphinx.SphinxRunner;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.io.IOUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.doxia.siterenderer.Renderer;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

@Mojo(name="generate", defaultPhase=LifecyclePhase.SITE)
public class SphinxMojo
extends AbstractMavenReport {
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="${plugin}", required=true, readonly=true)
    private PluginDescriptor pluginDesc;
    @Component
    private ArtifactFactory artifactFactory;
    @Component
    private ArtifactResolver resolver;
    @Component
    private ArtifactMetadataSource artifactMetadataSource;
    @Parameter(defaultValue="${localRepository}", required=true, readonly=true)
    private ArtifactRepository localRepository;
    @Parameter(defaultValue="${project.remoteArtifactRepositories}", required=true, readonly=true)
    private List remoteRepositories;
    @Parameter(defaultValue="${basedir}", required=true, readonly=true)
    private File basedir;
    @Parameter(defaultValue="${basedir}/src/site/sphinx", required=true)
    private File sourceDirectory;
    @Parameter(defaultValue="${project.reporting.outputDirectory}", required=true)
    private File outputDirectory;
    @Parameter(defaultValue="Documentation via sphinx", required=true)
    private String name;
    @Parameter(defaultValue="Documentation via sphinx", required=true)
    private String description;
    @Parameter(defaultValue="index", required=true)
    private String outputName;
    @Parameter(defaultValue="${project.build.directory}/sphinx", required=true, readonly=true)
    private File sphinxSourceDirectory;
    @Parameter(alias="builder", defaultValue="html")
    private String builder;
    @Parameter(alias="tags")
    private List<String> tags;
    @Parameter(alias="verbose", defaultValue="true")
    private boolean verbose;
    @Parameter(alias="warningsAsErrors", defaultValue="false")
    private boolean warningsAsErrors;
    @Parameter(alias="force", defaultValue="false")
    private boolean force;
    @Parameter(alias="fork", defaultValue="false")
    private boolean fork;
    @Parameter(alias="jvm")
    private String jvm;
    @Parameter(alias="argLine")
    private String argLine;
    @Parameter(alias="forkTimeoutSec")
    private int forkTimeoutSec;

    public String getDescription(Locale defaultLocale) {
        return this.description;
    }

    public String getName(Locale defaultLocale) {
        return this.name;
    }

    public String getOutputName() {
        return this.outputName;
    }

    public boolean isExternalReport() {
        return true;
    }

    protected Renderer getSiteRenderer() {
        return null;
    }

    protected String getOutputDirectory() {
        return this.outputDirectory.getAbsolutePath();
    }

    protected MavenProject getProject() {
        return this.project;
    }

    public void execute() throws MojoExecutionException {
        try {
            this.executeReport(Locale.getDefault());
        }
        catch (MavenReportException ex) {
            throw new MojoExecutionException("Failed to run the report", (Exception)((Object)ex));
        }
    }

    protected void executeReport(Locale locale) throws MavenReportException {
        this.outputDirectory.mkdirs();
        this.unpackSphinx();
        if (this.fork) {
            this.runForkedSphinx();
        } else {
            this.runSphinx();
        }
    }

    private void unpackSphinx() throws MavenReportException {
        if (!this.sphinxSourceDirectory.exists() && !this.sphinxSourceDirectory.mkdirs()) {
            throw new MavenReportException("Could not generate the temporary directory " + this.sphinxSourceDirectory.getAbsolutePath() + " for the sphinx sources");
        }
        if (this.verbose) {
            this.getLog().info((CharSequence)("Unpacking sphinx to " + this.sphinxSourceDirectory.getAbsolutePath()));
        }
        try {
            ArchiveInputStream input = new ArchiveStreamFactory().createArchiveInputStream("jar", SphinxMojo.class.getResourceAsStream("/sphinx.jar"));
            ArchiveEntry entry = input.getNextEntry();
            while (entry != null) {
                File archiveEntry = new File(this.sphinxSourceDirectory, entry.getName());
                archiveEntry.getParentFile().mkdirs();
                if (entry.isDirectory()) {
                    archiveEntry.mkdir();
                    entry = input.getNextEntry();
                    continue;
                }
                FileOutputStream out = new FileOutputStream(archiveEntry);
                IOUtils.copy((InputStream)input, (OutputStream)out);
                ((OutputStream)out).close();
                entry = input.getNextEntry();
            }
            input.close();
        }
        catch (Exception ex) {
            throw new MavenReportException("Could not unpack the sphinx source", ex);
        }
    }

    private String[] getSphinxRunnerCmdLine() {
        ArrayList<String> args = new ArrayList<String>();
        args.add("--sphinxSourceDirectory");
        args.add(this.sphinxSourceDirectory.getAbsolutePath());
        if (this.verbose) {
            args.add("-v");
        } else {
            args.add("-Q");
        }
        if (this.warningsAsErrors) {
            args.add("-W");
        }
        if (this.force) {
            args.add("-a");
            args.add("-E");
        }
        if (this.builder != null) {
            args.add("-b");
            args.add(this.builder);
        }
        if (this.tags != null && !this.tags.isEmpty()) {
            for (String tag : this.tags) {
                args.add("-t");
                args.add(tag);
            }
        }
        args.add("-n");
        args.add(this.sourceDirectory.getAbsolutePath());
        args.add(this.outputDirectory.getAbsolutePath());
        return args.toArray(new String[args.size()]);
    }

    private void runSphinx() throws MavenReportException {
        int result;
        if (this.verbose) {
            this.getLog().info((CharSequence)("Running sphinx on " + this.sourceDirectory.getAbsolutePath() + ", output will be placed in " + this.outputDirectory.getAbsolutePath()));
        }
        String[] args = this.getSphinxRunnerCmdLine();
        try {
            result = SphinxRunner.run(args);
        }
        catch (Exception ex) {
            throw new MavenReportException("Could not generate documentation", ex);
        }
        if (result != 0) {
            throw new MavenReportException("Sphinx report generation failed");
        }
    }

    private void runForkedSphinx() throws MavenReportException {
        String jvmBinary = this.jvm;
        if (jvmBinary == null || "".equals(jvmBinary)) {
            jvmBinary = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
        }
        this.getLog().debug((CharSequence)("Using JVM: " + jvmBinary));
        Commandline cmdLine = new Commandline();
        cmdLine.setWorkingDirectory(this.basedir);
        cmdLine.setExecutable(jvmBinary);
        if (this.argLine != null) {
            cmdLine.createArg().setLine(this.argLine.replace("\n", " ").replace("\r", " "));
        }
        try {
            cmdLine.addEnvironment("CLASSPATH", this.getPluginClasspath());
        }
        catch (Exception ex) {
            throw new MavenReportException("Could not determine the classpath of the plugin", ex);
        }
        String className = SphinxRunner.class.getName();
        String[] args = this.getSphinxRunnerCmdLine();
        cmdLine.createArg().setValue(className);
        for (String arg : args) {
            cmdLine.createArg().setValue(arg);
        }
        StreamConsumer infoStreamConsumer = new StreamConsumer(){

            public void consumeLine(String line) {
                SphinxMojo.this.getLog().info((CharSequence)line);
            }
        };
        StreamConsumer errorStreamConsumer = new StreamConsumer(){

            public void consumeLine(String line) {
                SphinxMojo.this.getLog().error((CharSequence)line);
            }
        };
        this.getLog().debug((CharSequence)cmdLine.toString());
        int result = 0;
        try {
            int timeout = this.forkTimeoutSec > 0 ? this.forkTimeoutSec : 0;
            result = CommandLineUtils.executeCommandLine((Commandline)cmdLine, (StreamConsumer)infoStreamConsumer, (StreamConsumer)errorStreamConsumer, (int)timeout);
        }
        catch (Exception ex) {
            throw new MavenReportException("Could not execute sphinx in a forked jvm", ex);
        }
        if (result != 0) {
            throw new MavenReportException("Sphinx report generation failed");
        }
    }

    private String getPluginClasspath() throws ArtifactResolutionException, ArtifactNotFoundException {
        HashSet<Artifact> artifacts = new HashSet<Artifact>(1);
        artifacts.add(this.pluginDesc.getPluginArtifact());
        Artifact originatingArtifact = this.artifactFactory.createBuildArtifact("dummy", "dummy", "1.0", "jar");
        ArtifactResolutionResult result = this.resolver.resolveTransitively(artifacts, originatingArtifact, this.remoteRepositories, this.localRepository, this.artifactMetadataSource);
        StringBuilder classpath = new StringBuilder();
        for (Object obj : result.getArtifacts()) {
            Artifact curArtifact = (Artifact)obj;
            if (classpath.length() > 0) {
                classpath.append(File.pathSeparatorChar);
            }
            classpath.append(curArtifact.getFile().getAbsolutePath());
        }
        return classpath.toString();
    }
}

