/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.common.util;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.Set;

public class ServiceRegistryUtil {
    private static Map<Class<?>, Set<?>> servicesCache = new HashMap();

    private ServiceRegistryUtil() {
    }

    public static <T> T getSingleService(Class<T> serviceInterface) throws IllegalStateException {
        T rval = null;
        Set<T> services = ServiceRegistryUtil.getServices(serviceInterface);
        if (services.size() > 1) {
            throw new IllegalStateException("Multiple implementations found of " + serviceInterface);
        }
        if (!services.isEmpty()) {
            rval = services.iterator().next();
        }
        return rval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> Set<T> getServices(Class<T> serviceInterface) {
        Map<Class<?>, Set<?>> map = servicesCache;
        synchronized (map) {
            if (servicesCache.containsKey(serviceInterface)) {
                return servicesCache.get(serviceInterface);
            }
            LinkedHashSet<T> services = new LinkedHashSet<T>();
            try {
                for (T service : ServiceLoader.load(serviceInterface)) {
                    services.add(service);
                }
            }
            catch (ServiceConfigurationError serviceConfigurationError) {
                // empty catch block
            }
            servicesCache.put(serviceInterface, services);
            return services;
        }
    }
}

