/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.common.util;

import com.ibm.icu.util.LocaleMatcher;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.TreeMap;

public class AbstractMessages {
    private static final List<String> FORMATS = Collections.singletonList("java.properties");
    private static final Map<String, ResourceBundle> bundles = new HashMap<String, ResourceBundle>();
    private final Class<? extends AbstractMessages> clazz;
    private static final ThreadLocal<Locale> tlocale = new ThreadLocal();
    private final LocaleMatcher localeMatcher;

    public static void setLocale(Locale locale) {
        tlocale.set(locale);
    }

    public static void clearLocale() {
        tlocale.set(null);
    }

    public AbstractMessages(Class<? extends AbstractMessages> c) {
        this.clazz = c;
        LocaleMatcher.Builder lmBuilder = LocaleMatcher.builder();
        for (Locale locale : Locale.getAvailableLocales()) {
            try {
                ResourceBundle bundle = ResourceBundle.getBundle(this.clazz.getName(), locale);
                lmBuilder.addSupportedLocale(bundle.getLocale());
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        lmBuilder.addSupportedLocale(Locale.ENGLISH).setDefaultLocale(Locale.ENGLISH);
        this.localeMatcher = lmBuilder.build();
    }

    private ResourceBundle getBundle(String name) {
        String bundleKey = this.getBundleKey(name);
        if (bundles.containsKey(bundleKey)) {
            return bundles.get(bundleKey);
        }
        ResourceBundle bundle = this.loadBundle();
        bundles.put(bundleKey, bundle);
        return bundle;
    }

    private String getBundleKey(String name) {
        Locale bestLocale = this.localeMatcher.getBestLocale(AbstractMessages.getLocale());
        if (bestLocale != null) {
            return name + "::" + bestLocale;
        }
        return name + "::en";
    }

    private ResourceBundle loadBundle() {
        String pkg = this.clazz.getPackage().getName();
        Locale locale = AbstractMessages.getLocale();
        return PropertyResourceBundle.getBundle(pkg + ".messages", locale, this.clazz.getClassLoader(), new ResourceBundle.Control(){

            @Override
            public List<String> getFormats(String baseName) {
                return FORMATS;
            }
        });
    }

    public static Locale getLocale() {
        if (tlocale.get() != null) {
            return tlocale.get();
        }
        return Locale.getDefault();
    }

    public static void addResourceBundle(String baseName, ResourceBundle resourceBundle) {
        Objects.requireNonNull(baseName);
        Objects.requireNonNull(resourceBundle);
        Locale locale = resourceBundle.getLocale();
        if (locale == null) {
            bundles.put(baseName + "::en", resourceBundle);
        } else {
            bundles.put(baseName + "::" + locale, resourceBundle);
        }
    }

    public String format(String key, Object ... params) {
        ResourceBundle bundle = this.getBundle(this.clazz.getName());
        if (bundle.containsKey(key)) {
            String msg = bundle.getString(key);
            return MessageFormat.format(msg, params);
        }
        return MessageFormat.format("!!{0}!!", key);
    }

    public Map<String, String> all() {
        TreeMap<String, String> rval = new TreeMap<String, String>();
        ResourceBundle bundle = this.getBundle(this.clazz.getName());
        Enumeration<String> keys = bundle.getKeys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            rval.put(key, bundle.getString(key));
        }
        return rval;
    }

    public Map<String, String> get(String name) {
        TreeMap<String, String> rval = new TreeMap<String, String>();
        ResourceBundle bundle = this.getBundle(name);
        Enumeration<String> keys = bundle.getKeys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            rval.put(key, bundle.getString(key));
        }
        return rval;
    }
}

