/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.common.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.json.JsonReadFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.MapType;
import com.fasterxml.jackson.datatype.guava.GuavaModule;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.module.jaxb.JaxbAnnotationModule;
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.Map;

public class JsonUtil {
    private static final ObjectMapper OM = ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().enable(new JsonReadFeature[]{JsonReadFeature.ALLOW_UNQUOTED_FIELD_NAMES}).enable(new JsonReadFeature[]{JsonReadFeature.ALLOW_TRAILING_COMMA}).enable(new JsonReadFeature[]{JsonReadFeature.ALLOW_SINGLE_QUOTES}).enable(new JsonReadFeature[]{JsonReadFeature.ALLOW_BACKSLASH_ESCAPING_ANY_CHARACTER}).enable(new JsonReadFeature[]{JsonReadFeature.ALLOW_NON_NUMERIC_NUMBERS}).enable(new JsonReadFeature[]{JsonReadFeature.ALLOW_JAVA_COMMENTS}).enable(new JsonReadFeature[]{JsonReadFeature.ALLOW_LEADING_DECIMAL_POINT_FOR_NUMBERS}).enable(new JsonReadFeature[]{JsonReadFeature.ALLOW_UNESCAPED_CONTROL_CHARS}).disable(new SerializationFeature[]{SerializationFeature.WRITE_DATES_AS_TIMESTAMPS})).addModule((Module)new JavaTimeModule())).addModule((Module)new ParameterNamesModule())).addModule((Module)new Jdk8Module())).addModule((Module)new GuavaModule())).addModule((Module)new JaxbAnnotationModule())).build();

    private JsonUtil() {
    }

    public static JsonNode toJsonTree(Object o) {
        return OM.valueToTree(o);
    }

    public static String toJsonString(Object o) {
        try {
            return OM.writeValueAsString(o);
        }
        catch (JsonProcessingException e) {
            throw new UncheckedIOException((IOException)((Object)e));
        }
    }

    public static <T> T toPojo(JsonNode payload, Class<T> klazz) {
        try {
            return (T)OM.treeToValue((TreeNode)payload, klazz);
        }
        catch (JsonProcessingException e) {
            throw new UncheckedIOException((IOException)((Object)e));
        }
    }

    public static <T> T toPojo(String payload, Class<T> klazz) {
        try {
            return (T)OM.readValue(payload, klazz);
        }
        catch (JsonProcessingException e) {
            throw new UncheckedIOException((IOException)((Object)e));
        }
    }

    public static <T, C extends Collection<T>> C toPojo(String payload, Class<T> klazz, Class<? extends Collection> collectionKlazz) {
        try {
            CollectionType type = OM.getTypeFactory().constructCollectionType(collectionKlazz, klazz);
            return (C)((Collection)OM.readValue(payload, (JavaType)type));
        }
        catch (JsonProcessingException e) {
            throw new UncheckedIOException((IOException)((Object)e));
        }
    }

    public static <K, V, C extends Map<K, V>> C toPojo(String payload, Class<K> keyKlazz, Class<V> objectKlazz, Class<? extends Map> mapKlazz) {
        try {
            MapType type = OM.getTypeFactory().constructMapType(mapKlazz, keyKlazz, objectKlazz);
            return (C)((Map)OM.readValue(payload, (JavaType)type));
        }
        catch (JsonProcessingException e) {
            throw new UncheckedIOException((IOException)((Object)e));
        }
    }

    public static ObjectMapper getObjectMapper() {
        return OM;
    }
}

