/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.common.util.ddl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.io.IOUtils;

public class DdlParser {
    public List<String> parse(File ddlFile) {
        List<String> list;
        FileInputStream is = null;
        try {
            is = new FileInputStream(ddlFile);
            list = this.parse(is);
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)is);
        return list;
    }

    public List<String> parse(InputStream ddlStream) throws IOException {
        String line;
        LinkedList<String> rval = new LinkedList<String>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(ddlStream, StandardCharsets.UTF_8));
        StringBuilder builder = new StringBuilder();
        boolean delimBlock = false;
        boolean isInMultiLineStatement = false;
        while ((line = reader.readLine()) != null) {
            if (line.startsWith("--") || line.trim().isEmpty()) continue;
            if (line.equals("/** DELIMITER-START **/")) {
                delimBlock = true;
                isInMultiLineStatement = true;
                continue;
            }
            if (line.equals("/** DELIMITER-END **/")) {
                delimBlock = false;
                isInMultiLineStatement = false;
                line = "";
            }
            if (!delimBlock) {
                if (line.endsWith("'") || line.endsWith("(") || line.endsWith("$$")) {
                    isInMultiLineStatement = true;
                }
                if (line.startsWith("'") || line.startsWith(")") || line.startsWith("$$")) {
                    isInMultiLineStatement = false;
                }
            }
            builder.append(line);
            builder.append("\n");
            if (isInMultiLineStatement) continue;
            String sqlStatement = builder.toString().trim();
            if (sqlStatement.endsWith(";")) {
                sqlStatement = sqlStatement.substring(0, sqlStatement.length() - 1);
            }
            rval.add(sqlStatement);
            builder = new StringBuilder();
        }
        return rval;
    }

    public static void main(String[] args) {
        String ddl = args[0];
        File file = new File(ddl);
        DdlParser parser = new DdlParser();
        List<String> list = parser.parse(file);
        System.out.println("Found " + list.size() + " SQL statements!");
        for (String line : list) {
            System.out.println("--");
            System.out.println(line);
        }
    }
}

