/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.group.internal;

import io.atomix.copycat.server.Commit;
import io.atomix.group.internal.GroupCommands;
import io.atomix.group.internal.MemberState;
import io.atomix.group.internal.MembersState;
import io.atomix.group.internal.MessageState;
import io.atomix.group.internal.QueueState;
import io.atomix.group.messaging.MessageProducer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;

class RequestReplyMessageState
extends MessageState {
    private int ack;
    private int fail;
    private List<Object> replies;

    public RequestReplyMessageState(Commit<GroupCommands.Message> commit, QueueState queue) {
        super(commit, queue);
    }

    @Override
    public boolean send(MembersState members) {
        if (((GroupCommands.Message)this.commit.operation()).delivery() == MessageProducer.Delivery.DIRECT) {
            MemberState member = members.get(((GroupCommands.Message)this.commit.operation()).member());
            if (member != null) {
                member.submit(this);
                return true;
            }
            this.sendReply(false, null);
            return false;
        }
        if (((GroupCommands.Message)this.commit.operation()).delivery() == MessageProducer.Delivery.RANDOM) {
            if (members.isEmpty()) {
                this.sendReply(false, null);
                return false;
            }
            members.get(new Random(((GroupCommands.Message)this.commit.operation()).id()).nextInt(members.size())).submit(this);
            return true;
        }
        if (((GroupCommands.Message)this.commit.operation()).delivery() == MessageProducer.Delivery.BROADCAST) {
            this.replies = new ArrayList<Object>(Collections.nCopies(members.size(), null));
            members.forEach(m -> m.submit(this));
            return true;
        }
        this.sendReply(false, null);
        return false;
    }

    @Override
    public void reply(GroupCommands.Reply reply) {
        if (((GroupCommands.Message)this.commit.operation()).delivery() == MessageProducer.Delivery.DIRECT || ((GroupCommands.Message)this.commit.operation()).delivery() == MessageProducer.Delivery.RANDOM) {
            this.sendReply(reply.succeeded(), reply.message());
        } else if (((GroupCommands.Message)this.commit.operation()).delivery() == MessageProducer.Delivery.BROADCAST) {
            if (reply.succeeded()) {
                ++this.ack;
                this.replies.set(this.ack + this.fail, reply.message());
            } else {
                ++this.fail;
            }
            if (this.ack + this.fail == this.replies.size()) {
                this.sendReply(this.fail == 0, this.replies);
                this.queue.close(this);
            }
        }
    }

    @Override
    public void expire() {
        if (((GroupCommands.Message)this.commit.operation()).delivery() == MessageProducer.Delivery.DIRECT || ((GroupCommands.Message)this.commit.operation()).delivery() == MessageProducer.Delivery.RANDOM) {
            this.sendReply(false, null);
        } else if (((GroupCommands.Message)this.commit.operation()).delivery() == MessageProducer.Delivery.BROADCAST) {
            ++this.fail;
            if (this.ack + this.fail == this.replies.size()) {
                this.sendReply(false, this.replies);
                this.queue.close(this);
            }
        }
    }
}

