/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.group.internal;

import io.atomix.copycat.server.Commit;
import io.atomix.group.internal.GroupCommands;
import io.atomix.group.internal.MemberState;
import io.atomix.group.internal.MembersState;
import io.atomix.group.internal.MessageState;
import io.atomix.group.internal.QueueState;
import io.atomix.group.messaging.MessageProducer;
import java.util.Random;

class SyncMessageState
extends MessageState {
    private int members = 1;
    private int ack;
    private int fail;

    public SyncMessageState(Commit<GroupCommands.Message> commit, QueueState queue) {
        super(commit, queue);
    }

    @Override
    public boolean send(MembersState members) {
        if (((GroupCommands.Message)this.commit.operation()).member() != null) {
            MemberState member = members.get(((GroupCommands.Message)this.commit.operation()).member());
            if (member != null) {
                member.submit(this);
                return true;
            }
            this.sendReply(false, null);
            return false;
        }
        if (((GroupCommands.Message)this.commit.operation()).delivery() == MessageProducer.Delivery.RANDOM) {
            if (members.isEmpty()) {
                this.sendReply(false, null);
                return false;
            }
            members.get(new Random(((GroupCommands.Message)this.commit.operation()).id()).nextInt(members.size())).submit(this);
            return true;
        }
        if (((GroupCommands.Message)this.commit.operation()).delivery() == MessageProducer.Delivery.BROADCAST) {
            if (members.isEmpty()) {
                this.sendReply(false, null);
                return false;
            }
            this.members = members.size();
            members.forEach(m -> m.submit(this));
            return true;
        }
        this.sendReply(false, null);
        return false;
    }

    @Override
    public void reply(GroupCommands.Reply reply) {
        if (reply.succeeded()) {
            ++this.ack;
        } else {
            ++this.fail;
        }
        if (this.ack + this.fail == this.members) {
            if (this.fail == 0) {
                this.sendReply(true, null);
            } else {
                this.sendReply(false, null);
            }
            this.queue.close(this);
        }
    }

    @Override
    public void expire() {
        ++this.fail;
        if (this.ack + this.fail == this.members) {
            this.sendReply(false, null);
            this.queue.close(this);
        }
    }
}

