/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.group.messaging.internal;

import io.atomix.catalyst.util.Assert;
import io.atomix.group.LocalMember;
import io.atomix.group.messaging.MessageConsumer;
import io.atomix.group.messaging.MessageProducer;
import io.atomix.group.messaging.internal.AbstractMessageConsumer;
import io.atomix.group.messaging.internal.AbstractMessageProducer;
import io.atomix.group.messaging.internal.AbstractMessageService;
import io.atomix.group.messaging.internal.MemberMessageConsumer;
import io.atomix.group.messaging.internal.MemberMessageProducer;
import io.atomix.group.messaging.internal.MessageConsumerService;
import io.atomix.group.messaging.internal.MessageProducerService;

public class MemberMessageService
extends AbstractMessageService {
    private final LocalMember member;

    public MemberMessageService(LocalMember member, MessageProducerService producerService, MessageConsumerService consumerService) {
        super(producerService, consumerService);
        this.member = (LocalMember)Assert.notNull((Object)member, (String)"member");
    }

    @Override
    public <T> AbstractMessageConsumer<T> consumer(String name) {
        return this.consumer(name, new MessageConsumer.Options());
    }

    @Override
    public <T> AbstractMessageConsumer<T> consumer(String name, MessageConsumer.Options options) {
        return new MemberMessageConsumer(name, options, this);
    }

    @Override
    public <T> AbstractMessageProducer<T> producer(String name) {
        return this.producer(name, new MessageProducer.Options().withDelivery(MessageProducer.Delivery.DIRECT).withExecution(MessageProducer.Execution.REQUEST_REPLY));
    }

    @Override
    public <T> AbstractMessageProducer<T> producer(String name, MessageProducer.Options options) {
        return new MemberMessageProducer(name, options, this, this.member);
    }
}

