/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.catalyst.transport.netty;

import io.atomix.catalyst.concurrent.ComposableFuture;
import io.atomix.catalyst.concurrent.ThreadContext;
import io.atomix.catalyst.transport.Address;
import io.atomix.catalyst.transport.Client;
import io.atomix.catalyst.transport.Connection;
import io.atomix.catalyst.transport.netty.NettyConnection;
import io.atomix.catalyst.transport.netty.NettyHandler;
import io.atomix.catalyst.transport.netty.NettyTls;
import io.atomix.catalyst.transport.netty.NettyTransport;
import io.atomix.catalyst.util.Assert;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.handler.codec.LengthFieldPrepender;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.concurrent.Future;
import java.net.SocketAddress;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyClient
implements Client {
    private static final Logger LOGGER = LoggerFactory.getLogger(NettyClient.class);
    private static final ByteBufAllocator ALLOCATOR = new PooledByteBufAllocator(true);
    private static final ChannelHandler FIELD_PREPENDER = new LengthFieldPrepender(4);
    private final NettyTransport transport;
    private final Map<Channel, NettyConnection> connections = new ConcurrentHashMap<Channel, NettyConnection>();

    public NettyClient(NettyTransport transport) {
        this.transport = (NettyTransport)Assert.notNull((Object)transport, (String)"transport");
    }

    public CompletableFuture<Connection> connect(Address address) {
        Assert.notNull((Object)address, (String)"address");
        ThreadContext context = ThreadContext.currentContextOrThrow();
        ComposableFuture future = new ComposableFuture();
        LOGGER.info("Connecting to {}", (Object)address);
        Bootstrap bootstrap = new Bootstrap();
        ((Bootstrap)((Bootstrap)bootstrap.group(this.transport.eventLoopGroup())).channel(NioSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>((CompletableFuture)future, context){
            final /* synthetic */ CompletableFuture val$future;
            final /* synthetic */ ThreadContext val$context;
            {
                this.val$future = completableFuture;
                this.val$context = threadContext;
            }

            protected void initChannel(SocketChannel channel) throws Exception {
                ChannelPipeline pipeline = channel.pipeline();
                if (NettyClient.this.transport.properties().sslEnabled()) {
                    pipeline.addFirst(new ChannelHandler[]{new SslHandler(new NettyTls(NettyClient.this.transport.properties()).initSslEngine(true))});
                }
                pipeline.addLast(new ChannelHandler[]{FIELD_PREPENDER});
                pipeline.addLast(new ChannelHandler[]{new LengthFieldBasedFrameDecoder(NettyClient.this.transport.properties().maxFrameSize(), 0, 4, 0, 4)});
                ChannelHandler[] channelHandlerArray = new ChannelHandler[1];
                channelHandlerArray[0] = new NettyHandler(NettyClient.this.connections, this.val$future::complete, this.val$context, NettyClient.this.transport.properties());
                pipeline.addLast(channelHandlerArray);
            }
        });
        bootstrap.option(ChannelOption.TCP_NODELAY, (Object)this.transport.properties().tcpNoDelay());
        bootstrap.option(ChannelOption.SO_KEEPALIVE, (Object)this.transport.properties().tcpKeepAlive());
        bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)this.transport.properties().connectTimeout());
        bootstrap.option(ChannelOption.ALLOCATOR, (Object)ALLOCATOR);
        if (this.transport.properties().sendBufferSize() != -1) {
            bootstrap.option(ChannelOption.SO_SNDBUF, (Object)this.transport.properties().sendBufferSize());
        }
        if (this.transport.properties().receiveBufferSize() != -1) {
            bootstrap.option(ChannelOption.SO_RCVBUF, (Object)this.transport.properties().receiveBufferSize());
        }
        bootstrap.connect((SocketAddress)address.socketAddress()).addListener(arg_0 -> NettyClient.lambda$connect$1(address, context, (CompletableFuture)future, arg_0));
        return future;
    }

    public CompletableFuture<Void> close() {
        ThreadContext.currentContextOrThrow();
        int i = 0;
        CompletableFuture[] futures = new CompletableFuture[this.connections.size()];
        for (Connection connection : this.connections.values()) {
            futures[i++] = connection.close();
        }
        return CompletableFuture.allOf(futures);
    }

    private static /* synthetic */ void lambda$connect$1(Address address, ThreadContext context, CompletableFuture future, Future channelFuture) throws Exception {
        if (channelFuture.isSuccess()) {
            LOGGER.info("Connected to {}", (Object)address);
        } else {
            context.execute(() -> future.completeExceptionally(channelFuture.cause()));
        }
    }
}

