/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.test.junit;

import io.bootique.BQRuntime;
import io.bootique.command.CommandOutcome;
import io.bootique.test.junit.BQRuntimeDaemon;
import io.bootique.test.junit.BQTestRuntimeBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.junit.rules.ExternalResource;

public class BQDaemonTestFactory
extends ExternalResource {
    protected Map<BQRuntime, BQRuntimeDaemon> runtimes;

    static BQRuntimeDaemon getDaemon(Map<BQRuntime, BQRuntimeDaemon> runtimes, BQRuntime runtime) {
        return Objects.requireNonNull(runtimes.get(runtime), "Runtime is not registered with the factory: " + runtime);
    }

    protected void after() {
        Map<BQRuntime, BQRuntimeDaemon> localRuntimes = this.runtimes;
        if (localRuntimes != null) {
            localRuntimes.values().forEach(runtime -> {
                try {
                    runtime.stop();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
        }
    }

    protected void before() {
        this.runtimes = new HashMap<BQRuntime, BQRuntimeDaemon>();
    }

    public <T extends Builder<T>> Builder<T> app(String ... args) {
        return new Builder(this.runtimes, args);
    }

    public Optional<CommandOutcome> getOutcome(BQRuntime runtime) {
        return this.getDaemon(runtime).getOutcome();
    }

    public void start(BQRuntime runtime) {
        this.getDaemon(runtime).start();
    }

    protected BQRuntimeDaemon getDaemon(BQRuntime runtime) {
        return BQDaemonTestFactory.getDaemon(this.runtimes, runtime);
    }

    public void stop(BQRuntime runtime) {
        this.getDaemon(runtime).stop();
    }

    public static class Builder<T extends Builder<T>>
    extends BQTestRuntimeBuilder<T> {
        private static final Function<BQRuntime, Boolean> AFFIRMATIVE_STARTUP_CHECK = runtime -> true;
        private Map<BQRuntime, BQRuntimeDaemon> runtimes;
        private Function<BQRuntime, Boolean> startupCheck;
        private long startupTimeout = 5L;
        private TimeUnit startupTimeoutTimeUnit = TimeUnit.SECONDS;

        protected Builder(Map<BQRuntime, BQRuntimeDaemon> runtimes, String[] args) {
            super(args);
            this.runtimes = runtimes;
            this.startupCheck = AFFIRMATIVE_STARTUP_CHECK;
        }

        public T startupCheck(Function<BQRuntime, Boolean> startupCheck) {
            this.startupCheck = Objects.requireNonNull(startupCheck);
            return (T)this;
        }

        public T startupAndWaitCheck() {
            this.startupCheck = runtime -> BQDaemonTestFactory.getDaemon(this.runtimes, runtime).getOutcome().isPresent();
            return (T)this;
        }

        public T startupTimeout(long timeout, TimeUnit unit) {
            this.startupTimeout = timeout;
            this.startupTimeoutTimeUnit = unit;
            return (T)this;
        }

        public BQRuntime createRuntime() {
            BQRuntime runtime = this.bootique.createRuntime();
            BQRuntimeDaemon testRuntime = new BQRuntimeDaemon(runtime, this.startupCheck, this.startupTimeout, this.startupTimeoutTimeUnit);
            this.runtimes.put(runtime, testRuntime);
            return runtime;
        }

        public BQRuntime start() {
            BQRuntime runtime = this.createRuntime();
            BQDaemonTestFactory.getDaemon(this.runtimes, runtime).start();
            return runtime;
        }
    }
}

