/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.test.junit;

import io.bootique.BQRuntime;
import io.bootique.command.CommandOutcome;
import io.bootique.log.BootLogger;
import io.bootique.log.DefaultBootLogger;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;

public class BQRuntimeDaemon {
    private BootLogger logger = new DefaultBootLogger(false);
    private BQRuntime runtime;
    private long startupTimeout;
    private TimeUnit startupTimeoutTimeUnit;
    private ExecutorService executor;
    private Function<BQRuntime, Boolean> startupCheck;
    private Optional<CommandOutcome> outcome;

    public BQRuntimeDaemon(BQRuntime runtime, Function<BQRuntime, Boolean> startupCheck, long startupTimeout, TimeUnit startupTimeoutTimeUnit) {
        this.runtime = runtime;
        this.startupCheck = startupCheck;
        this.executor = Executors.newCachedThreadPool();
        this.outcome = Optional.empty();
        this.startupTimeout = startupTimeout;
        this.startupTimeoutTimeUnit = startupTimeoutTimeUnit;
    }

    public Optional<CommandOutcome> getOutcome() {
        return this.outcome;
    }

    public BQRuntime getRuntime() {
        return this.runtime;
    }

    public void start() {
        this.executor.submit(() -> {
            this.outcome = Optional.of(this.runtime.run());
            return this.outcome;
        });
        this.checkStartupSucceeded(this.startupTimeout, this.startupTimeoutTimeUnit);
    }

    protected void checkStartupSucceeded(long timeout, TimeUnit unit) {
        boolean success;
        Future<Boolean> startupFuture = this.executor.submit(() -> {
            try {
                while (!this.startupCheck.apply(this.runtime).booleanValue()) {
                    this.logger.stderr("Daemon runtime hasn't started yet...");
                    Thread.sleep(500L);
                }
                return true;
            }
            catch (InterruptedException e) {
                this.logger.stderr("Timed out waiting for server to start");
                return false;
            }
            catch (Throwable th) {
                this.logger.stderr("Server error", th);
                return false;
            }
        });
        try {
            success = startupFuture.get(timeout, unit);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            throw new RuntimeException(String.format("Daemon failed to start in %s ms", unit.toMillis(timeout)));
        }
        if (!success) {
            throw new RuntimeException("Daemon failed to start");
        }
        this.logger.stderr("Daemon runtime started...");
    }

    public void stop() {
        this.runtime.shutdown();
        this.executor.shutdownNow();
        try {
            this.executor.awaitTermination(3L, TimeUnit.SECONDS);
            this.logger.stderr("Daemon runtime stopped...");
        }
        catch (InterruptedException e) {
            this.logger.stderr("Interrupted while waiting for shutdown", (Throwable)e);
        }
    }
}

