/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.test.junit;

import io.bootique.BQRuntime;
import io.bootique.test.junit.BQTestRuntimeBuilder;
import java.util.ArrayList;
import java.util.Collection;
import org.junit.rules.ExternalResource;

public class BQTestFactory
extends ExternalResource {
    private Collection<BQRuntime> runtimes;

    protected void after() {
        Collection<BQRuntime> localRuntimes = this.runtimes;
        if (localRuntimes != null) {
            localRuntimes.forEach(runtime -> {
                try {
                    runtime.shutdown();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
        }
    }

    protected void before() {
        this.runtimes = new ArrayList<BQRuntime>();
    }

    public Builder newRuntime() {
        return this.app(new String[0]);
    }

    public Builder app(String ... args) {
        return new Builder(this.runtimes, args);
    }

    public static class Builder
    extends BQTestRuntimeBuilder<Builder> {
        private Collection<BQRuntime> runtimes;

        private Builder(Collection<BQRuntime> runtimes, String[] args) {
            super(args);
            this.runtimes = runtimes;
        }

        public BQRuntime createRuntime() {
            BQRuntime runtime = this.bootique.createRuntime();
            this.runtimes.add(runtime);
            return runtime;
        }
    }
}

