/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.jersey;

import com.google.inject.Inject;
import com.google.inject.Injector;
import io.bootique.jersey.GuiceInjectInjector;
import javax.inject.Singleton;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Feature;
import javax.ws.rs.core.FeatureContext;
import org.glassfish.hk2.api.InjectionResolver;
import org.glassfish.hk2.api.TypeLiteral;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.glassfish.jersey.server.ResourceConfig;

public class GuiceBridgeFeature
implements Feature {
    private static final String INJECTOR_PROPERTY = "io.bootique.jersey.injector";

    static void register(ResourceConfig config, Injector injector) {
        config.property(INJECTOR_PROPERTY, (Object)injector);
        config.register(GuiceBridgeFeature.class);
    }

    static Injector getInjector(Configuration configuration) {
        Injector injector = (Injector)configuration.getProperty(INJECTOR_PROPERTY);
        if (injector == null) {
            throw new IllegalStateException("Injector is not available in JAX RS runtime. Use property 'io.bootique.jersey.injector' to set it");
        }
        return injector;
    }

    public boolean configure(FeatureContext context) {
        context.register((Object)new AbstractBinder(){

            protected void configure() {
                this.bind(GuiceInjectInjector.class).to((TypeLiteral)new TypeLiteral<InjectionResolver<Inject>>(){}).in(Singleton.class);
            }
        });
        return true;
    }
}

