/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.jersey;

import com.google.inject.ConfigurationException;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Singleton;
import com.google.inject.TypeLiteral;
import com.google.inject.internal.Annotations;
import com.google.inject.internal.Errors;
import com.google.inject.internal.ErrorsException;
import io.bootique.jersey.GuiceBridgeFeature;
import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.lang.reflect.Type;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Context;
import org.glassfish.hk2.api.Injectee;
import org.glassfish.hk2.api.InjectionResolver;
import org.glassfish.hk2.api.ServiceHandle;

@Singleton
public class GuiceInjectInjector
implements InjectionResolver<Inject> {
    private Injector injector;

    public GuiceInjectInjector(@Context Configuration configuration) {
        this.injector = GuiceBridgeFeature.getInjector(configuration);
    }

    public boolean isConstructorParameterIndicator() {
        return true;
    }

    public boolean isMethodParameterIndicator() {
        return false;
    }

    public Object resolve(Injectee injectee, ServiceHandle<?> serviceHandle) {
        if (injectee.getRequiredType() instanceof Class) {
            Key key;
            TypeLiteral typeLiteral = TypeLiteral.get((Type)injectee.getRequiredType());
            Errors errors = new Errors((Object)injectee.getParent());
            try {
                key = Annotations.getKey((TypeLiteral)typeLiteral, (Member)((Member)((Object)injectee.getParent())), (Annotation[])injectee.getParent().getDeclaredAnnotations(), (Errors)errors);
            }
            catch (ErrorsException e) {
                errors.merge(e.getErrors());
                throw new ConfigurationException((Iterable)errors.getMessages());
            }
            return this.injector.getInstance(key);
        }
        throw new IllegalStateException("Can't process injection point: " + injectee.getRequiredType());
    }
}

