/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.jersey;

import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.TypeLiteral;
import com.google.inject.multibindings.Multibinder;
import io.bootique.ConfigModule;
import io.bootique.config.ConfigurationFactory;
import io.bootique.jersey.GuiceBridgeFeature;
import io.bootique.jersey.JerseyModuleExtender;
import io.bootique.jersey.JerseyResource;
import io.bootique.jersey.JerseyServletFactory;
import io.bootique.jersey.ResourceModelDebugger;
import io.bootique.jetty.JettyModule;
import io.bootique.jetty.MappedServlet;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.container.DynamicFeature;
import javax.ws.rs.core.Feature;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.servlet.ServletContainer;

public class JerseyModule
extends ConfigModule {
    private static final String URL_PATTERN = "/*";

    public static JerseyModuleExtender extend(Binder binder) {
        return new JerseyModuleExtender(binder);
    }

    @Deprecated
    public static Multibinder<Feature> contributeFeatures(Binder binder) {
        return Multibinder.newSetBinder((Binder)binder, Feature.class);
    }

    @Deprecated
    public static Multibinder<DynamicFeature> contributeDynamicFeatures(Binder binder) {
        return Multibinder.newSetBinder((Binder)binder, DynamicFeature.class);
    }

    @Deprecated
    public static Multibinder<Object> contributeResources(Binder binder) {
        return Multibinder.newSetBinder((Binder)binder, (Key)Key.get(Object.class, JerseyResource.class));
    }

    @Deprecated
    public static Multibinder<Package> contributePackages(Binder binder) {
        return Multibinder.newSetBinder((Binder)binder, Package.class);
    }

    public void configure(Binder binder) {
        JettyModule.extend((Binder)binder).addMappedServlet((TypeLiteral)new TypeLiteral<MappedServlet<ServletContainer>>(){});
        JerseyModule.extend(binder).initAllExtensions();
    }

    @Singleton
    @Provides
    private ResourceConfig createResourceConfig(Injector injector, Set<Feature> features, Set<DynamicFeature> dynamicFeatures, @JerseyResource Set<Object> resources, Set<Package> packages, @JerseyResource Map<String, Object> properties) {
        ResourceConfig config = new ResourceConfig();
        packages.forEach(p -> config.packages(true, new String[]{p.getName()}));
        resources.forEach(r -> config.register(r));
        features.forEach(f -> config.register(f));
        dynamicFeatures.forEach(df -> config.register(df));
        config.addProperties(properties);
        config.register(ResourceModelDebugger.class);
        GuiceBridgeFeature.register(config, injector);
        return config;
    }

    @Provides
    @Singleton
    private MappedServlet<ServletContainer> provideJerseyServlet(ConfigurationFactory configFactory, ResourceConfig config) {
        return ((JerseyServletFactory)configFactory.config(JerseyServletFactory.class, this.configPrefix)).initUrlPatternIfNotSet(URL_PATTERN).createJerseyServlet(config);
    }
}

